# Siliconflow - Api Reference

**Pages:** 45

---

## 创建语音转文本请求

**URL:** llms-txt#创建语音转文本请求

Source: https://docs.siliconflow.cn/cn/api-reference/audio/create-audio-transcriptions

post /audio/transcriptions
Creates an audio transcription.

---

## 创建文本转语音请求

**URL:** llms-txt#创建文本转语音请求

Source: https://docs.siliconflow.cn/cn/api-reference/audio/create-speech

post /audio/speech
Generate audio from input text. The data generated by the interface is the binary data of the audio, which requires the user to handle it themselves. Reference:https://docs.siliconflow.cn/capabilities/text-to-speech#5

---

## 删除参考音频

**URL:** llms-txt#删除参考音频

Source: https://docs.siliconflow.cn/cn/api-reference/audio/delete-voice

post /audio/voice/deletions
Delete user-defined voice style

---

## 上传参考音频

**URL:** llms-txt#上传参考音频

Source: https://docs.siliconflow.cn/cn/api-reference/audio/upload-voice

post /uploads/audio/voice
Upload user-provided voice style, which can be in base64 encoding or file format. Refer to (https://docs.siliconflow.cn/capabilities/text-to-speech#2-2)

---

## 参考音频列表获取

**URL:** llms-txt#参考音频列表获取

Source: https://docs.siliconflow.cn/cn/api-reference/audio/voice-list

get /audio/voice/list
Get list of user-defined voice styles

---

## 取消batch任务

**URL:** llms-txt#取消batch任务

Source: https://docs.siliconflow.cn/cn/api-reference/batch/cancel-batch

post /batches/{batch_id}/cancel
This endpoint cancels a batch identified by its unique ID.

---

## 创建batch任务

**URL:** llms-txt#创建batch任务

Source: https://docs.siliconflow.cn/cn/api-reference/batch/create-batch

post /batches
Upload files

---

## 获取batch任务详情

**URL:** llms-txt#获取batch任务详情

Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-batch

get /batches/{batch_id}
Retrieves a batch.

---

## 获取batch任务列表

**URL:** llms-txt#获取batch任务列表

Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-batch-list

get /batches
List your organization's batches.

---

## 获取文件列表

**URL:** llms-txt#获取文件列表

Source: https://docs.siliconflow.cn/cn/api-reference/batch/get-file-list

get /files
Returns a list of files.

---

## 上传文件

**URL:** llms-txt#上传文件

Source: https://docs.siliconflow.cn/cn/api-reference/batch/upload-file

post /files
Upload files

---

## 创建对话请求（OpenAI）

**URL:** llms-txt#创建对话请求（openai）

Source: https://docs.siliconflow.cn/cn/api-reference/chat-completions/chat-completions

post /chat/completions
Creates a model response for the given chat conversation.

---

## 创建对话请求（Anthropic）

**URL:** llms-txt#创建对话请求（anthropic）

Source: https://docs.siliconflow.cn/cn/api-reference/chat-completions/messages

post /messages
Creates a model response for the given chat conversation.

---

## 创建嵌入请求

**URL:** llms-txt#创建嵌入请求

Source: https://docs.siliconflow.cn/cn/api-reference/embeddings/create-embeddings

post /embeddings
Creates an embedding vector representing the input text.

---

## 创建图片生成请求

**URL:** llms-txt#创建图片生成请求

Source: https://docs.siliconflow.cn/cn/api-reference/images/images-generations

post /images/generations
Creates an image response for the given prompt. The URL for the generated image is valid for one hour. Please make sure to download and store it promptly to avoid any issues due to URL expiration.

---

## 获取用户模型列表

**URL:** llms-txt#获取用户模型列表

Source: https://docs.siliconflow.cn/cn/api-reference/models/get-model-list

get /models
Retrieve models information.

---

## 创建重排序请求

**URL:** llms-txt#创建重排序请求

Source: https://docs.siliconflow.cn/cn/api-reference/rerank/create-rerank

post /rerank
Creates a rerank request.

---

## 获取用户账户信息

**URL:** llms-txt#获取用户账户信息

Source: https://docs.siliconflow.cn/cn/api-reference/userinfo/get-user-info

get /user/info
Get user information including balance and status

---

## 获取视频生成链接请求

**URL:** llms-txt#获取视频生成链接请求

Source: https://docs.siliconflow.cn/cn/api-reference/videos/get_videos_status

post /video/status
Get the user-generated video. The URL for the generated video is valid for one hour. Please make sure to download and store it promptly to avoid any issues due to URL expiration.

---

## 创建视频生成请求

**URL:** llms-txt#创建视频生成请求

Source: https://docs.siliconflow.cn/cn/api-reference/videos/videos_submit

post /video/submit
Generate a video through the input prompt. This API returns the user's current request ID. The user needs to poll the status interface to get the specific video link. The generated result is valid for 10 minutes, so please retrieve the video link promptly.

---

## 记得填写您在步骤2中获取的 API Key

**URL:** llms-txt#记得填写您在步骤2中获取的-api-key

RERANK_PROXY_SILICONFLOW_PROXY_API_KEY={your-siliconflow-api-key}

---

## AstrBot

**URL:** llms-txt#astrbot

**Contents:**
- 部署并配置 AstrBot
  - 通过 Docker 部署
  - 访问 AstrBot WebUI
  - 配置对话模型
  - 在线聊天测试（可选）
- 接入消息平台（以飞书为例）
  - 创建飞书机器人
  - 配置 AstrBot
  - 设置回调和权限
  - 创建版本

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-astrbot

[AstrBot](https://astrbot.app/) 是一个开源的一站式 Agent 聊天机器人平台及开发框架。支持将大模型能力接入 QQ、飞书、钉钉、Slack、Telegram、Discord 等多种主流消息平台上，提供开箱即用的 RAG、Agent、MCP 等功能，并拥有丰富的 API 接口，以方便进行二次开发和集成。AstrBot 拥有强大的社区和丰富的插件生态。

请确保你的环境上已经安装了 Docker 和 Git。

> 如果您的网络环境在中国大陆境内，上述命令将无法正常拉取。您可能需要修改 compose.yml 文件，将其中的 `image: soulter/astrbot:latest` 替换为 `image: m.daocloud.io/docker.io/soulter/astrbot:latest`。

默认账户和密码均为 `astrbot`，登录后会提示修改默认密码。

在硅基流动 [API Keys](https://cloud.siliconflow.cn/me/account/ak) 页面创建一个新的 API Key，留存备用。

在硅基流动[模型页面](https://cloud.siliconflow.cn/me/models)选择需要使用的模型，留存模型名称备用。

进入 AstrBot WebUI，点击左栏 `服务提供商` -> `新增提供商` -> 选择 `硅基流动`。

粘贴上面创建和选择的 `API Key` 和 `模型名称`，点击保存，完成创建。您可以点击下方 `服务提供商可用性` 的 `刷新` 按钮测试配置是否成功。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=5ac54713a1288c2c830a3f5f6e8e3eee" data-og-width="2604" width="2604" data-og-height="1658" height="1658" data-path="images/usercases/AstrBot/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=83cbb80ca38bbe988b219741a00b8eae 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=e60640e65d06d0551a05e8dcfe0aa742 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=85ca9d848dcb3a2c7902bf6c66c9e010 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=9ca10946d080ba3aae615707bf240f32 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=2e7e8e2acb0dd2015eba3f83e96acff1 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/1.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=eb7b45927985394b778903fe1e4dc590 2500w" />
</Frame>

您可在 AstrBot WebUI 左栏 `聊天` 页面来测试您配置的模型。

此处以飞书为例。您可前往 [AstrBot 文档](https://docs.astrbot.app/) -> `部署` -> `部署消息平台` 查看其他消息平台的接入方式。

前往 [开发者后台](https://open.feishu.cn/app) ，创建企业自建应用。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=10112a5aa32670db5790ad9eddf720a4" data-og-width="1880" width="1880" data-og-height="1590" height="1590" data-path="images/usercases/AstrBot/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7d82fafdb4d7364abdac6b72340fe7ca 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7da73b62f11a15e52166b722a1e473be 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=95022df887e8cf36a95ed0b9970038a2 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=ef46cafacfd7bdd5794d4bdaa903cef4 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c2c3288ba58c5f893c175e7728a6d8f0 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/2.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7558c116f7f6b98293a8606811107695 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=02e3c237c5e65ca4ae58260a7ba1eac7" data-og-width="1510" width="1510" data-og-height="938" height="938" data-path="images/usercases/AstrBot/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a621df52c98ba0d2dddf5f759330d0f9 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=012ea126718878f2f14a7a4bd0e2a866 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=666e200b79933e2a1cf30af15a2137ce 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=9ab66e07ee05b2be2a50aab9c9945c47 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=a8239f8ca87865c70b825a88044a8eda 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/3.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=25792f697d173b82ff0970464d8f702e 2500w" />
</Frame>

点击凭证与基础信息，获取 app\_id 和 app\_secret。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=24543719b83dc854e7f53d636c0e43ab" data-og-width="2866" width="2866" data-og-height="848" height="848" data-path="images/usercases/AstrBot/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=4b06402a9bb370547c88db2d190e0474 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f35128f8369ca2f6a8afc7328f45418f 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=20e26038e5b190380179b2e0f57a6d92 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f21d5aad9036b4df42b1b88ecb1d212b 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=aa35ddd24047e47a0b6ab1aaf23d3f6c 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/4.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c550a629c727d446f4159d9126a79ebb 2500w" />
</Frame>

1. 进入 AstrBot 的管理面板
2. 点击左边栏 `机器人`
3. 然后在右边的界面中，点击 `+ 创建机器人`
4. 选择 `lark(飞书)`

* ID: 随意填写，用于区分不同的消息平台实例。
* 启用: 勾选。
* app\_id: 获取的 app\_id
* app\_secret: 获取的 app\_secret
* 飞书机器人的名字

如果您正在用国际版飞书，请将 `domain` 设置为 `https://open.larksuite.com`。

在下方的 `配置文件` 中，点击 `选择配置文件` 右边的 ↗️ 箭头按钮。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=52091141707622cb90fab4b9ef90e274" data-og-width="1576" width="1576" data-og-height="642" height="642" data-path="images/usercases/AstrBot/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=104c3ec6561f39b88f8a315997ed4ad2 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=de8aca4f8a7e4b7f824d7193d82c7a12 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=2f31969dcca8350fed635048896b4e4d 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6eb5f241fead38aaf08f8e3aec665490 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d19591b56a5e265bbd059df73ba7c600 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/5.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c1883754604973eecab153992eb59db5 2500w" />
</Frame>

在呼出的配置页面中，点击默认聊天模型右边的选择提供商按钮，选择刚刚创建的硅基流动的提供商，点击右下角的保存按钮。保存成功后关闭该页面。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0154c0b36f03825fcaeebe925bf97281" data-og-width="2590" width="2590" data-og-height="1654" height="1654" data-path="images/usercases/AstrBot/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6ceb7aa556805ae669ed2f04f9168ce8 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=82198eed259e5bd7e3bd7d892dd8c1c6 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=c653424b505fb6d84291afec87571c56 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=b07ce4f80d9d146fc4c6276088daf43a 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=47aa5f8b7b428430e5170a314f3e159b 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/6.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6f34a25c74b9dad798fe318d5cf39105 2500w" />
</Frame>

接下来，点击事件与回调，使用长连接接收事件，点击保存。**如果上一步没有成功启动，那么这里将无法保存。**

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=552e60b933ae2a7a2c21769ee7736689" data-og-width="2880" width="2880" data-og-height="1800" height="1800" data-path="images/usercases/AstrBot/7.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=6f44dab9f1984881ca59392be19a92cb 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f3e0229964cf29fd61fac4c6f7b4e37c 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=aade885f48ed0e2444084f83ed12e106 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=10acfe189814cd3f987d5157528873dd 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d78fc3ab4838abe13688aae8936eef23 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/7.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=37b132e82c40a5909efa430c7b1976e2 2500w" />
</Frame>

点击添加事件，消息与群组，下拉找到 `接收消息`，添加。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=33f1e7e8a64b6057d185c372edff4820" data-og-width="2010" width="2010" data-og-height="1428" height="1428" data-path="images/usercases/AstrBot/8.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=7ff15286cbd43c5ec4ce4db4ad02a036 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=d174a76daa8c4321a9372daf20e9bb75 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=e3f7f1616416e56eabb1f578fb258be2 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=dd123b432c264748b417d06674319ea6 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=189e0e2c2f15365e03fccce018dc85d6 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/8.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=dd9123c5eee0b8d0dc8a4f583b4fccfd 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=5b9e6ea94353ccf4b9675db972166442" data-og-width="2242" width="2242" data-og-height="774" height="774" data-path="images/usercases/AstrBot/9.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=bbfb689a9d96c4fbd4765a065ed2b7fc 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0f8efbc59b5942cae010942914c405ec 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=4c305ac0fdf78fe073be6aa72ec55e62 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=21c58010537cac55af44cde66a6306b5 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=35befe9082376285e94c9457219b9ca7 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/9.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=be1eae6eba0669f66729707a8b62b331 2500w" />
</Frame>

接下来，点击权限管理，点击开通权限，输入 `im:message:send,im:message,im:message:send_as_bot`。添加筛选到的权限。

再次输入 `im:resource:upload,im:resource` 开通上传图片相关的权限。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c400c1a7fc5ec882553a441d91e60f51" data-og-width="2880" width="2880" data-og-height="1800" height="1800" data-path="images/usercases/AstrBot/10.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=f0e2b2c02605e19c35444838d883881a 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c88110dfad2913e8fca12c56bf122ed9 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=db620c87f6d6bd3bdb4b8a1992c4bbff 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=fc5044ae4311761652a784924f2b30da 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=c25d122d7f4aaf66953e06890295d103 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/10.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=8dee14cb5cc9bf7088e7a22ee92afec7 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=b610eb6232ede4bdf7716402f8a43c65" data-og-width="2528" width="2528" data-og-height="804" height="804" data-path="images/usercases/AstrBot/11.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=280&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=e2b00c5654d9481f2c31588186e300c7 280w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=560&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=85a7cfe6ba7db92f11026a6f9e0d86c4 560w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=840&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=9cda16d3d533440a4ab155df78c6f2d2 840w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=1100&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=01a5d4f4bfea8fbfa59f4dd4e7563f44 1100w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=1650&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=6dc51327139258dcd9bfb3703057845e 1650w, https://mintcdn.com/siliconflow-37161621/c3_OkqqCATGrz6lr/images/usercases/AstrBot/11.png?w=2500&fit=max&auto=format&n=c3_OkqqCATGrz6lr&q=85&s=828f0a7c4c9a219b9cd555b3482c8869 2500w" />
</Frame>

填写版本号，更新说明，可见范围后点击保存，确认发布。

进入飞书 APP（网页版飞书无法添加机器人），点进群聊，点击右上角按钮->群机器人->添加机器人。

搜索刚刚创建的机器人的名字。比如教程创建了 `AstrBot` 机器人：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=47d4a292ecb0902701baa9a3a64669b5" data-og-width="2632" width="2632" data-og-height="1500" height="1500" data-path="images/usercases/AstrBot/12.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=280&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=2b861eee1059ff3a9b99e7f2cc327411 280w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=560&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=f8c331971a1cbc5521712ed79c441614 560w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=840&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=0270a33c750db775e1053b78168cb951 840w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=1100&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=ca1748881a86353587eb3891212e6f30 1100w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=1650&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=041ec28a8e0c5e8e425b6fd0316e2377 1650w, https://mintcdn.com/siliconflow-37161621/2dL2FkzVjBU52Ce2/images/usercases/AstrBot/12.png?w=2500&fit=max&auto=format&n=2dL2FkzVjBU52Ce2&q=85&s=005620faa1987305390195474b2170aa 2500w" />
</Frame>

在群内发送测试消息 `hi`，机器人将做出响应。

您可以前往 [AstrBot 文档](https://docs.astrbot.app/) 查看更多功能和配置。

**Examples:**

Example 1 (unknown):
```unknown
> 如果您的网络环境在中国大陆境内，上述命令将无法正常拉取。您可能需要修改 compose.yml 文件，将其中的 `image: soulter/astrbot:latest` 替换为 `image: m.daocloud.io/docker.io/soulter/astrbot:latest`。

### 访问 AstrBot WebUI
```

---

## Chat2Graph

**URL:** llms-txt#chat2graph

**Contents:**
- 关于 Chat2Graph
- 获取 API Key
- 部署 Chat2Graph
  - 下载 Chat2Graph
  - 准备执行环境
  - 构建 Chat2Graph
  - 配置 SiliconFlow 模型
  - 启动 Chat2Graph
- 使用 Chat2Graph
  - 注册图数据库

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chat2graph

[Chat2Graph](https://github.com/TuGraph-family/chat2graph) 是一个图原生的智能体系统（Graph Native Agentic System），通过利用图数据结构在关系建模、可解释性等符号主义的天然优势，对智能体的推理、规划、记忆、知识、工具协作等关键能力进行增强，同时借助智能体技术推进图数据库智能化，降低用图门槛，加速内容生成，实现与图对话。做到图计算技术与人工智能技术的深度融合。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b4edf470dabd717027290ec549a1bfa8" data-og-width="3602" width="3602" data-og-height="1329" height="1329" data-path="images/usercases/chat2graph/head.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=24880ac8637c59fa43e7d9e7ca7dccb4 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=24237af5b8493b3e744836370046c277 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=526defecf6db8e172226586a6fe3ac92 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=389cb54560e5d3e54fb95a9faab858aa 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ed3288137670ed02aec90a65b2e14f4d 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/head.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=72b20956685542cfc472bf2401637df6 2500w" />
</Frame>

1. 打开 [SiliconFlow](https://cloud.siliconflow.cn/) 官网 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开 [API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

准备符合要求的 Python 和 NodeJS 版本。

* **Python**: 推荐[Python == 3.10](https://www.python.org/downloads)。
* **NodeJS**: 推荐[NodeJS >= v16](https://nodejs.org/en/download)。

您可以使用 `conda` 等工具来管理您的 Python 环境：

### 配置 SiliconFlow 模型

当看到如下日志时，表示 Chat2Graph 已成功启动：

你可以在浏览器访问 [http://localhost:5010/](http://localhost:5010/) 使用 Chat2Graph。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=4a6abd9759e3729bf74637225a3b6f5e" data-og-width="3456" width="3456" data-og-height="938" height="938" data-path="images/usercases/chat2graph/index.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=af6c3b5da462d30a03ec9e6ff0141155 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=25f52f8bd4cef52daaf19450e5745832 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=28ea8b5a5a5c26d5667229531871e819 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d8d259aa987cd2e4cd2de7e22703e43e 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cd1553a0976a69e99889a7914637aadc 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/index.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3af990120e9c447210d13703bdd268b7 2500w" />
</Frame>

提前注册图数据库实例，可以体验完整的 Chat2Graph 的「与图对话」功能。当前支持 [Neo4j](https://neo4j.com/) 和 [TuGraph](https://tugraph.tech/) 图数据库。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=57b23f26b2148da9026dc2a4d88f21fe" data-og-width="3456" width="3456" data-og-height="638" height="638" data-path="images/usercases/chat2graph/gdb-mng.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3fd414a8f216d5b0e345b5e4412f8a36 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=365f43b1fe2ab153c61204805291a8ca 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0927b4cc7bb3a0e69176bfcbffd7c190 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d4497f389e9752aad60ed1d598e5341e 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9c637dbc737ec8abe72b14a4718b3dd8 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/gdb-mng.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f645fa88f2898c81f0aa1785ad558ac3 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0728436e48c79bcc462d6f89f77e1f67" data-og-width="3400" width="3400" data-og-height="1832" height="1832" data-path="images/usercases/chat2graph/chat-layout-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a5ea30531de53a8839769681c56406e3 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6ff0cbd00177f019c0f88f2adcdc263a 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=273c18806066de83d970161a8c014729 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7ecb0608c0521b2d527a424711c80ee1 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=646cbc96db4ca19dd2d24a880248ace5 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-2.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bc80b46f82f2267cbbd8b9f13998efec 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a473d0c4f579c13b882c90846ceb9bd5" data-og-width="3412" width="3412" data-og-height="1838" height="1838" data-path="images/usercases/chat2graph/chat-layout-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cbe0794d0ce2ce20dd0fcc0db98f99ce 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=97debd6f6217a4145002c4b53ea70bdc 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=56aed90bf6aca7c73fbb6fb9bf8f4ab4 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=6c336b04c87451ccf22053e191390ecd 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c7de2be8f610638ad3f4f4de2377e11c 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chat2graph/chat-layout-3.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1abc807286e76a54536f402463cbeb38 2500w" />
</Frame>

Chat2Graph 提供了清晰简洁的 SDK API，让你轻松定制智能体系统。

仿写 `chat2graph.yml` 文件，一键初始化智能体：

**Examples:**

Example 1 (unknown):
```unknown
### 准备执行环境

准备符合要求的 Python 和 NodeJS 版本。

* **Python**: 推荐[Python == 3.10](https://www.python.org/downloads)。
* **NodeJS**: 推荐[NodeJS >= v16](https://nodejs.org/en/download)。

您可以使用 `conda` 等工具来管理您的 Python 环境：
```

Example 2 (unknown):
```unknown
### 构建 Chat2Graph

一键构建 Chat2Graph：
```

Example 3 (unknown):
```unknown
### 配置 SiliconFlow 模型

准备 `.env` 配置文件：
```

Example 4 (unknown):
```unknown
填写 SiliconFlow 模型配置：
```

---

## Chatbox

**URL:** llms-txt#chatbox

**Contents:**
- 1 关于 Chatbox
- 2 安装使用 Chatbox
- 3 在 Chatbox 中使用硅基流动模型
  - 3.1 配置硅基流动 API 密钥
  - 3.2 在 Chatbox 中配置
  - 3.3 开始聊天
  - 3.4 使用技巧
- 4 参考资料

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chatbox

Chatbox 是一个流行的大语言模型的全平台聊天客户端，特点是功能强大、安装简单。你可以用它接入各种大语言模型，然后在任何设备（电脑、手机、网页）上和 AI 聊天。

Chatbox 不仅提供简单好用的 AI 聊天功能，还提供了一系列强大功能：

* Artifact 预览：在 Chatbox 中你可以预览 AI 生成代码的实际效果，比如让 AI 帮你做一个网页、贪吃蛇游戏，然后在 Chatbox 中直接运行。
* 图表制作：让 AI 绘制思维导图、流程图、统计图表。
* 文档理解和图形视觉：可以向 AI 发送文档或者图片。
* 网页解析与识别：可以向 AI 发送链接，讨论网页内容等。

浏览器访问 [Chatbox 官网](https://chatboxai.app/)下载安装包。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-website.png" />
</Frame>

Chatbox 支持所有的主流操作系统，包括 Windows、MacOS 和 Linux，手机系统支持 iOS 和 Android。下载安装包后，在系统中直接安装即可。或者也可以访问和使用 Chatbox 的网页版本。

## 3 在 Chatbox 中使用硅基流动模型

### 3.1 配置硅基流动 API 密钥

访问 [API 密钥](https://cloud.siliconflow.cn/account/ak)新建或复制已有密钥。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/siliconcloud.png" />
</Frame>

### 3.2 在 Chatbox 中配置

2. 在模型提供方界面选择 SiliconFlow。

3. 输入个人的 SiliconFlow API 密钥。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a83b0e8d37d57ff0b7260c3dfce1d4ba" data-og-width="2050" width="2050" data-og-height="1366" height="1366" data-path="images/usercases/chatbox/image_0.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=560bae9c31d8adf857ce6a3f51b7c704 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98c7498f407744deb6fdcc5c9458dfd1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=62952fabd17d66e5d04b922a11c9865b 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=721a31479918119f6f90eb5842ce721d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98a75c3d372541e404ae1251081486a3 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatbox/image_0.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a94fbbd4e77279bec1eb9cd1fd7d22a5 2500w" />
</Frame>

按照上面步骤，基本上已经配置成功了，简单聊天测试一下。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatting.png" />
</Frame>

在结尾这里在顺带介绍一些 Chatbox 的使用技巧。

#### 3.4.1 利用 Chatbox 的图表能力，在聊天中生成可视化图表

Chatbox 的“做图表”助手会生成各种图表，在聊天中可以更方便地让你理解一些数据。

注意：为了更好的效果，需要选择更聪明更强大的模型。模型能力将直接决定图表的效果。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-charts.png" />
</Frame>

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-charts2.png" />
</Frame>

#### 3.4.2 利用 Chatbox 的 Artifact 预览功能，查看 AI 生成代码的运行效果

Chatbox 的 Artifact 预览功能，则可以让你直接预览 AI 生成前端代码的实际运行效果。

注意：为了更好的效果，需要选择更聪明更强大的模型。模型能力将直接决定生成代码的效果。

<Frame>
  <img src="https://bennhuang.com/chatbox-siliconcloud-integration-guide/chatbox-with-artifact.png" />
</Frame>

除了这些技巧外，在 Chatbox 简单易用的外表下，还隐藏着非常多强大的功能，有很多值得探索的地方。

* [Chatbox 官网](https://chatboxai.app/)
* [如何在 Chatbox 中接入 SiliconFlow - 超简单完整教程](https://bennhuang.com/posts/chatbox-siliconcloud-integration-guide/)

---

## ChatHub

**URL:** llms-txt#chathub

**Contents:**
- 关于 ChatHub
- 安装 ChatHub
- 在ChatHub中使用SiliconFlow模型
- 在 ChatHub 中进行多模型对比

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chathub

[ChatHub](https://chathub.gg/zh) 是一个流行的大语言模型聚合插件，特点是可以同时和多个模型聊天，方便对比回答。ChatHub 在全球拥有数十万活跃用户。

浏览器打开 [ChatHub 官网](https://chathub.gg/zh)，点击“新增至Chrome”按钮安装 ChatHub 浏览器插件：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=07bd1f9df0e347d73d3b2cb9719dfdb5" data-og-width="1200" width="1200" data-og-height="438" height="438" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=5da062e4a2c928e595f0c26ad956b35f 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3cb64f2a26fdad90532ac6f9ec2b67f1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8b0b0bd9777ad089cea28524f75fb764 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=dcdffe37c4c37da7752a6343d9b1c677 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=86507eb8245cccb45fd295cef349d84b 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-1.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bff183f4232eb08e5840caff53558b65 2500w" />
</Frame>

安装后，将自动打开 ChatHub 设置页面.

## 在ChatHub中使用SiliconFlow模型

1、在 ChatHub 设置中找到“自定义机器人”模块，点击“添加”按钮

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9d511f21fdac6c49cafbf223c7bdcf94" data-og-width="944" width="944" data-og-height="442" height="442" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d7a1a21c6dbd157176bdd8a777be4c7e 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0fe473ad3a1ffb30bc6c900762d8cb5e 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bb42c7a930027766eef06d37f0119c7c 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=36c89c457d748f72ba0aa2a512754220 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=cdd3fbfc1884557a0a31d84080f18750 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-2.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2351611fd22a3b11af55d6ce78c3c232 2500w" />
</Frame>

1. 输入机器人名称
2. 选择 SiliconFlow 作为提供方
3. 输入 SiliconFlow 密钥
4. 填写 SiliconFlow 支持的任何模型

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=46a601e1de52ac47d3b7b52419d1f4e6" data-og-width="1200" width="1200" data-og-height="1042" height="1042" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3499c936f24c3936171952981fa5a6f6 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1ea03ba710281e69c7e1abe0f4d7bac9 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2ff3ada8913a8853def7a37feb9fdeb5 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=d0bf3a6bba1908dc65c4306e5f9d0362 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=98b82c6ee9f04b989b682add1f2ae74f 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-3.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=c0ffb50da8957b44106d997c0d44c91e 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=752740890bc58e3c9287811af21b5db5" data-og-width="824" width="824" data-og-height="394" height="394" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=8261e01a57668353fd26eb805e7d5803 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b74804a647095c337440c6d3ca90b176 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=76d8192224b24700c28427533b95d355 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3f3989061a2b37d42a48592ab4d7c07d 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=f17c4995471bd1d2841bc67e21390556 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-4.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=edea26c2a40810fda03948e02dc36077 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=9ac25b4c3896753c0ed753ce2ef14b47" data-og-width="1200" width="1200" data-og-height="601" height="601" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=ce223fb8770887a2cdbca846d21aa775 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=0562bdc1fd75f7367dd578f48ffd84b1 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=fc50f07c9e0dd1f1644592563079f1e4 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=a940703cb0d25921dbcc76d2ede39aa0 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7e0be5fb21a8aa287414540751dd200b 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-5.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=1ac609e7f1910c72c7208203e7953505 2500w" />
</Frame>

## 在 ChatHub 中进行多模型对比

你可以重复上面的步骤在 ChatHub 添加其他模型，然后你就可以使用 ChatHub 的 All-in-One 功能同时和多个模型聊天（最多可以同时和 6 个模型对话）：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=93d5429cf96454c2f403a123cf2d1408" data-og-width="1200" width="1200" data-og-height="900" height="900" data-path="images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=49bf8446d3bc568eb965976b4fea7ba4 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7f5683ca2d388b58644c49a5b138e8ac 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=10d4f1ad49d8d2702ce67b1a0706f673 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=2bf95b99b16c4fa2f9a158beffa51fe0 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=be4862fb2fba68b42c6aa9bf9515ccd8 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chathub/use-siliconcloud-in-chathub-6.jpg?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=72d275b56727f8f4a806ae6353b91269 2500w" />
</Frame>

除了核心的对比功能外，ChatHub 还有提示词库、代码预览等强大的功能，可以在 [ChatHub 官方文档](https://doc.chathub.gg/introduction)了解更多。

---

## Chatika

**URL:** llms-txt#chatika

**Contents:**
- 1. 关于 Chatika
- 2. 安装与配置
- 3. 对话界面
  - 对话设置和模板
  - 对话管理
- 4. 在线搜索
- 5. 未来展望

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-chatika

**Chatika** 是一款 iOS 平台的免费 AI 对话客户端，让用户可以自己输入 API 密钥自由调用各供应商，或使用本地部署的 Ollama 的各种 AI 大语言模型进行对话。具备：**高隐私性** 、**高自由度**、**丰富的聊天功能**、**原生开发**等特性。

最新版 Chatika 合作硅基流动，特别为新用户预设了免 API Key 的全模型试用模式。

在苹果 AppStore 搜索 **Chatika** 或下方直接扫码即可，**最低系统要求 iOS 17.1** 。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3f081536599b40cecdb86ea9ed4424c9" data-og-width="865" width="865" data-og-height="364" height="364" data-path="images/usercases/chatika/Chatika_Banner.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=280&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=3ecee992558a90dc10411ec292a04a8e 280w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=560&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=7b5a5757f13fdc6a39c9ec83b3dfc999 560w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=840&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=b288a20ac34c92ab5fa88ac11e9644f6 840w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=1100&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=bf1a32db0ebf8a1ee074ad86fd9b40c6 1100w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=1650&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=4e77c3722a4d740094b6890a47987876 1650w, https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/Chatika_Banner.png?w=2500&fit=max&auto=format&n=dWzWFIJ4RDcgcXPP&q=85&s=84d130f9123a7e21896f020beec565c9 2500w" />
</Frame>

初次运行会进入欢迎页面（根据系统语言自动设置 app 语言，目前支持中英）。

随后被引导到下图的 Provider 设置界面，可以自己输入对应的 API 密钥，也可以配置 Ollama Host 在本地局域网调用。

还可以**点击 SiliconFlow（硅基流动）进行试用，激活试用就有 1w tokens 的试用额度**。模型方面只要硅基流动有的模型，全开放使用，激活试用或直接输入 Api keys 就可以开始对话了。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_1.gif" />
</Frame>

* **窗口顶部**：供应商名称旁显示 “State” 徽章，标识模型能力。若为多模态模型，将显示“图片”徽章，支持发送图片。

* **中间区域**：为消息交流主体内容。可以在消息下方进行额外的 **“引用”，“创建分支”，“回到某个点重发”，“重新生成回答”** 等额外操作。

* **底部操作栏**：“Persona”（人设）快捷选择栏，已预设了常用 AI 人设，并支持 AI 人设设置

<Frame>
  <img width="300" src="https://mintcdn.com/siliconflow-37161621/dWzWFIJ4RDcgcXPP/images/usercases/chatika/gif_2.gif?s=8ebb1971d7895409c68b5109e8aa634b" data-og-width="720" data-og-height="1280" data-path="images/usercases/chatika/gif_2.gif" data-optimize="true" data-opv="3" />
</Frame>

点击聊天标题或者右上角的配置按钮，会进入 **当前对话** 的设置界面。可以直接更改对话的模型/人设，需要注意的是 **额外自定义提示词**。这个**额外**的提示词，仅仅作用于当前的对话，不影响其他对话的人设。另外如果对当前这个聊天的设置满意，可以直接保存对话设置为模板供将来复用。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_3.gif" />
</Frame>

点击对话界面左上角的**边栏**按钮，则会打开边栏弹窗。

在这里可以对对话进行**搜索**，**星标**和**批量删除**。长按单个对话，还可以对单个对话进行直接重命名/删除/或用整个对话创建副本分支。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_4.gif" />
</Frame>

Chatika 支持在线信息搜索，只需填入搜索服务商的 API Key, 即可在聊天调取打开实时在线检索结果。

<Frame>
  <img width="300" src="https://mintlify.s3.us-west-1.amazonaws.com/siliconflow-37161621/images/usercases/chatika/gif_5.gif" />
</Frame>

Chatika 是一款独立软件和兴趣项目，计划在不久的将来会开源本 App。

Chatika 当前主要满足的是在手机端尽可能自由的 AI 对话，待时机更成熟的时候，可能会考虑增加有限的 MCP 支持，实现一定程度的 Agent 化操作。

如果有 Bug 和其他反馈，联系 Email: [dev@chatika.app](mailto:dev@chatika.app)

---

## Deep Research Web UI

**URL:** llms-txt#deep-research-web-ui

**Contents:**
- 1. 介绍
- 2. 如何使用
  - 2.1 配置 AI 大模型服务
  - 2.2 配置联网搜索模型
  - 3. 开始使用

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-deep-research-web-ui

Deep Research Web UI 是一个由人工智能驱动的研究助手，通过结合搜索引擎、网络抓取和大语言模型，可以让 AI 根据某个问题自己搜索资料并且不断深挖，最后输出一份研究报告。

* 💰 **低成本**：可以用很低的成本实现类似 ChatGPT、Perplexity、秘塔等产品的“深度研究”效果
* 🚀 **隐私安全**：所有配置和 API 请求均在浏览器端完成，并且可以自部署
* 🕙 **实时反馈**：流式传输 AI 响应并在界面实时展示
* 🌳 **搜索可视化**：使用树状结构展示研究过程，支持使用英文搜索词
* 📄 **支持导出 PDF**：将最终研究报告导出为 Markdown 和 PDF 格式
* 🤖 **多模型支持**：底层使用纯提示词而非结构化输出等新特性，兼容更多大模型供应商

项目开源地址： [GitHub](https://github.com/AnotiaWang/deep-research-web-ui)

打开 [Deep Research Web UI 官网](https://deep-research.ataw.top)，点击右上角的“⚙️”按钮打开设置弹窗。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=74855ab4aff29ff4e76b4cfe837aafc2" data-og-width="2018" data-og-height="1228" data-path="images/usercases/deep-research/deep-research-showcase-1.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0188893cf0c66aefb533d64100a694d5 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2474fce08a3cb4eab51d07dd4ce5cf1f 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d7ca9742122330891fae3e057927cb63 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=afe2a2e54a380746a2c83efbe7d44aff 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1c79eeff0b5abc9271aeab4dc084edcb 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-1.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=df84ce3cea86c535ebb23056233cda08 2500w" />
</Frame>

1. 在硅基流动官网注册或者登录一个账号。
2. 在 [API 密钥](https://cloud.siliconflow.cn/account/ak)中生成一个新的 API key，然后复制一下。
3. 回到 Deep Research 网页，在设置的 AI 服务部分，选择“SiliconFlow 硅基流动”，在“API 密钥”一栏里粘贴刚才生成的 API key。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e9d8785b85c961bd665fcc90d6017bc1" data-og-width="1114" data-og-height="504" data-path="images/usercases/deep-research/deep-research-showcase-2.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=425790a3dc32809fb43e1037f5b7aaa4 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5a72168454158c1636ad0928ba0a5817 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=247625c0489124d308ad9378b735b8f1 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ad0abd23e4c70f4c6966a9b628f0b3a4 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3332a4acc645a9e726f54e88bfb22734 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-2.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb2c8d0ebc5d80b65788ceb2611925c0 2500w" />
</Frame>

4. 在“模型名称”一栏，点击右侧的下拉按钮（也可以在输入框里输入模型名称来筛选），选择想要使用的模型。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c52e3da58f54fa66d47e293956b32613" data-og-width="1006" data-og-height="622" data-path="images/usercases/deep-research/deep-research-showcase-3.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1d5f6322528e3a69ce7ed31f30459852 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ea056eab27749fa8afb88f556366ff09 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=22a76edb87682f1d38909c37692b97d9 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f53b62888c55766d0f873fd443a85e55 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=db84d13acdb3431a09dd4dbf9f2befc7 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-3.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c28632a0294bad53602d900d7ae3a244 2500w" />
</Frame>

5. （可选）设置上下文长度：如果要做大规模的研究，建议配置“上下文长度”选项，不要超过所选模型的最大上下文长度，避免请求失败。

目前支持 Tavily 和 Firecrawl，后续会增加支持更多搜索服务。这里我们选择 Tavily，因为它提供了每月 1000 次的免费搜索，足够大部分场景使用。

1. 在 [Tavily 官网](https://app.tavily.com/home)注册一个账号。然后在控制台里新建一个 API key 并复制。
   * Key Name 可以填写 Deep Research。
   * Key Type 根据你的使用情况决定，如果是轻度使用，可以选择“Development”；重度使用则选择“Production”，支持更高的请求频率。
   * 注意保管好 API key 不要泄露。

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=38091917a8c3192578a882810e915e48" data-og-width="2874" data-og-height="1444" data-path="images/usercases/deep-research/deep-research-showcase-4.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dbdb3c5773475900bba73d3e67299bd3 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=11f476bca37995e44b71784fb6524828 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5bb0983f8ad00a2a7aec203e31ef57ea 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd3c1cda23780b9d8e4c0bad49250798 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a713687c9acf47a71e01ce5a04200af8 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-4.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=3c7708ef60498453271a86c48e71fb79 2500w" />
</Frame>

2. 回到 Deep Research 网页，在设置的“联网搜索服务”部分，选择 “Tavily”；在“API 密钥”一栏填写刚才生成的 API key。
3. （可选）设置搜索时使用的语言。AI 模型默认会使用你网页的当前语言来搜索和回复，不过如果你想用英文搜索词来查找更高质量的资料，可以把“使用语言”设置成 English。

本项目在每一步都做了说明，力求降低使用门槛。可以用它来查找第一手资料、了解自己感兴趣的话题、查找新闻并汇总等等。例如，查找一下 NVIDIA RTX 50 系列显卡的信息：

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=80b8c6802056d9c41f7c504d34af62a7" data-og-width="3374" data-og-height="1996" data-path="images/usercases/deep-research/deep-research-showcase-5.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ec8cd6a520a58838ee648173a4442aed 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a95fa37321a68c07268f8d7f1943c54b 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4168674b009279ecc82605e60f16b5bb 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=90f59824e0b6d5e0fb309cd3c30b3501 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fb6a855befe49babaa77878536702815 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-5.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f8b159304879a37ea8fd57e1033bbe52 2500w" />
</Frame>

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ec6edaa0e39f82270d4514bd174e87f4" data-og-width="1832" data-og-height="1502" data-path="images/usercases/deep-research/deep-research-showcase-6.webp" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=98ab525f2a16f1d82eecabcccc386de3 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1958b8ac6c979ac77c0217ea87677d04 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=378bd478d3ca58f9b3d063774227166c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1f16528fa9055c72dc7dac79906e349a 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2f46c60889524a3fb486ec88c915394c 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/deep-research/deep-research-showcase-6.webp?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0cbfafa0fe18ef569a045c69e865c993 2500w" />
</Frame>

本项目正在活跃更新中，如果遇到问题可以前往 [GitHub 仓库](https://github.com/AnotiaWang/deep-research-web-ui)反馈。

---

## eechat

**URL:** llms-txt#eechat

**Contents:**
- 关于 eechat
- 下载 eechat
- 安装 eechat 并配置硅基流动模型
  - 1. 安装 eechat（以 Windows 为例）
  - 2. 获取 API Key
  - 3. 配置 API Key
  - 4. 配置模型
- 在聊天中使用模型
- 相关参考

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-eechat

[eechat](https://github.com/Lucassssss/eechat) 是一款开源免费的国产 AI 应用，支持 Windows、macOS 和 Linux，集成了聊天、多模态指令执行（MCP）、知识库问答（RAG）、语音识别（ASR）、语音合成（TTS）等功能模块。

* **开箱即用**，无需代码基础，适合非技术背景用户。
* **免费开源**，国产的免费开源应用，数据都存储在本地
* **多模型支持**，同时支持 API 模型和本地模型聊天，可以自定义配置自己喜欢的模型
* **丰富的支持**，支持 MCP、RAG 和插件支持

本文档将演示硅基流动在 eechat 中的使用。

* **[官网下载](https://ee.chat)**
* **[开源下载](https://github.com/Lucassssss/eechat/releases)**

## 安装 eechat 并配置硅基流动模型

### 1. 安装 eechat（以 Windows 为例）

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ba8d8b81e27820c74707f0c95d699a4d" data-og-width="872" width="872" data-og-height="630" height="630" data-path="images/usercases/eechat/win-install-1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cd8685dcc56984b75b04b2b176522099 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2fcf3bff4fe33d5c15e296c011eae9f0 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e7834d45694cd49d780fed2ad51ba85d 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=71a40c08cd4eb47c131713bcc42b7a23 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=5fa0f18e12311b56f4ae32b8bdfdfd86 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-1.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=75829c3c67e224282d8857a2aac131a3 2500w" />
</Frame>

* 点击“浏览”，选择安装路径，确认后开始安装。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1b96c15cfd33f53e4fcf24da38dbf592" data-og-width="1736" width="1736" data-og-height="861" height="861" data-path="images/usercases/eechat/win-install-2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a35dede4850c893d8a3fa60b1ae86da2 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6a3745facec3b6a5ef6296bcba574031 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a4bda9376cb683fc9925b24e3e30c95c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b068e5d568ee1075f8e61b6d4e4b9278 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=90834744f264a7613245775a2fd27e03 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-2.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=855980f5b86a5b32915a565293d82853 2500w" />
</Frame>

* 安装完成后，打开 eechat，按图示操作

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=aac28c4a290f329331ff4510d8ae419d" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/win-install-3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=dea56b3bff20dfd2b7bcf22e894dc06a 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=fd7d98eb777ff22c2a0dfa5b4602bf19 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=447615949d0eb2464eaee2c77a92f09c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c33c16ffb4b33cceb297210c8177429a 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6f37307c80c1f87ceb2486a6a9aa5bd7 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-3.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=042f1d8b4682749ec5e31ddcc820b1bc 2500w" />
</Frame>

1. 点击左侧菜单的最后一个图标“设置”
2. 选中设置下的 “API 模型”
3. 在 API 模型提供商中选择 "硅基流动"
4. 点击获取 API Key，打开硅基流动登录页面，如果已登录会进入硅基流动控制台页面

* 点击获取 API Key 后，会在浏览器打开硅基流动登录页面，登录您的账户信息

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=266abd055e7865e472e92716ed2e1f92" data-og-width="950" width="950" data-og-height="918" height="918" data-path="images/usercases/eechat/win-install-4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=095d6df5a5ee88564cd39f65f8a5f8ff 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8996eec22b0eef86feade63b7858117b 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=f43f91d9754e8a9ab1ffdc62a23cd15e 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=16d24079bb1e6c9809b49df9abb7f2ef 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=02361e1e0e6b535c15210465f776fa4b 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-install-4.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e851dd1cc9e120a28594174e2fbad748 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=9b7925bd8f0b23a07d5b4667928dbf60" data-og-width="1731" width="1731" data-og-height="1246" height="1246" data-path="images/usercases/eechat/siliconflow-create-key.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=6c0343d58d2a5ee7c0d24058248d06db 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d72ecb7dbb106478a6155889c9da021e 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8cfe4b6991ce2970a70c34f0ed224c84 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=273a3b30b1457bd1b89eaab3b4b35375 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0a15e79a26e611f3f0a73a6a56920daf 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-create-key.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=de977183fe4173eacd919386dbf7ffc9 2500w" />
</Frame>

* 在 eechat 中配置提供商和 API Key

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=97fd4503a0000fcab1ecb3fc8e976332" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/win-config-provider.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=e6d7c3d3247e79e998a486d65d54094b 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b05f599c2832adfcdf8f16ac20ba7d9d 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8496c5d9eb002f41fefc9ec5da9faef6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=0bf22091368a7d79555712059f627c81 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=2677f986a3d965e952a54fa322dd67f4 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/win-config-provider.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=065cdf98c3d7697203337489d0757ec8 2500w" />
</Frame>

1. 在 eechat 的 API 模型提供商中选择 "硅基流动"
2. 在 API Key 中粘贴刚刚创建的 API Key
3. 在 API URL 中输入 `https://api.siliconflow.cn/v1`
4. 点击测试连接，如果测试成功就可以直接对话了，如果测试失败，请检查 API Key 或 API URL 是否正确。

> 硅基流动的 API 接口默认是`https://api.siliconflow.cn/v1`，如有变动以 API 手册为准。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d4d40f1ab52e15201d94f87767dc52ad" data-og-width="1516" width="1516" data-og-height="1253" height="1253" data-path="images/usercases/eechat/add-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c0fd1af55ce444fb157337e619c322bd 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c4baeea2db6f59d77f2afb7c1f408ce7 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=1d2dd02be5c94fc9bf152f0c994a849c 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=684543d47c2fca30dc271fa285e88c64 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8faa6d4ad8f3adef510c77963a7c5d18 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d139285402d7f2fa2591dfeef66957f5 2500w" />
</Frame>

* 在弹出的浏览器窗口中，选择所需模型（如 Qwen3），如下图 ①
* 复制对应模型卡片的模型 ID，如下图 ②

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=511a4eee76d1f2b344ee54f220cc594d" data-og-width="2244" width="2244" data-og-height="1093" height="1093" data-path="images/usercases/eechat/siliconflow-copy-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=ef5e9b596e474beda89f841485c714cb 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=836c968bd1d9957f0bab7134912ab5d7 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=014f29d87c147122dbad05305fef6bce 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c8e8d394d14a81d50b35102058d9a0cf 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7bd4496a83225b4c92927009fba63cc9 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/siliconflow-copy-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=18ef9bc112b0ab5de7cc20509b03e941 2500w" />
</Frame>

* 点击 eechat "新增模型" 按钮，在弹出的窗口中，粘贴刚刚复制的模型 ID，点击确定

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cb4245eba2e3925a1c27c2cf79db62db" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/add-model-id.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c63d5b0526d2936cf6241867eb02a01e 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=40dc025fa75b44a7bf08f599806186e6 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=a6c812771fee72fc10afc3e8ca16a85f 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=488bf82ecb93f2eed6729520cd830ece 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=8a184c0345eb042b1d24961ce18b43e6 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/add-model-id.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=d40e8b9ddc87f0c9b73792f151b6e068 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=cab4a4a765cc97ca7c2db69b58c16ab2" data-og-width="1936" width="1936" data-og-height="1404" height="1404" data-path="images/usercases/eechat/select-model.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=7c29ece4950074322e1f683b16086d17 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=404acb0c66626f79ea930ff3d3d115bc 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=91087e496e93144b48e9fd7d52f520db 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b558727384e1d197db463bbcf606a791 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=da00e30b0192ac16d130ab952ab77e2b 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/select-model.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=69b2ccc01339861e6ad97252421186ba 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=36dba0dc1bd73f18ecd65eb2b2dc79e3" data-og-width="1934" width="1934" data-og-height="1403" height="1403" data-path="images/usercases/eechat/talk.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=280&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4ae2da671e74f60ba6cfcb0fec1727b2 280w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=560&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=414ff84caffd241e82185a7b65ca595c 560w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=840&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=4f6139db5294abce537956bbf289b3a6 840w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=1100&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=61f7b33c7f819a71faa3a73aa729317d 1100w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=1650&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=c8274fccdc27d0d9b2053d9e7d044a80 1650w, https://mintcdn.com/siliconflow-37161621/U5A4_TpbD-AXNY4h/images/usercases/eechat/talk.png?w=2500&fit=max&auto=format&n=U5A4_TpbD-AXNY4h&q=85&s=b5e49b6255b67fbfadb2044dce99483d 2500w" />
</Frame>

* 💻 [eechat 官网](https://ee.chat)
* 🧑‍💻 [eechat GitHub](https://github.com/Lucassssss/eechat)
* ☁️ [硅基流动 API 密钥](https://cloud.siliconflow.cn/account/ak)
* 📘 [硅基流动官方文档](https://docs.siliconflow.cn)

如何你觉得 [eechat](https://github.com/Lucassssss/eechat) 不错，欢迎给一个 Star ⭐️ 支持开源项目发展！

---

## 填写 SiliconFlow 控制台提供的 Api Key

**URL:** llms-txt#填写-siliconflow-控制台提供的-api-key

**Contents:**
- 3. 修改 FastGPT 配置文件
- 4. 重启 FastGPT
- 5. 体验测试
  - 测试对话和图片识别
  - 测试知识库导入和知识库问答
  - 测试语音播放
  - 测试语言输入
- 总结

CHAT_API_KEY=sk-xxxxxx
json  theme={null}
{
    "llmModels": [
    {
      "provider": "Other", // 模型提供商，主要用于分类展示，目前已经内置提供商包括：https://github.com/labring/FastGPT/blob/main/packages/global/core/ai/provider.ts, 可 pr 提供新的提供商，或直接填写 Other
      "model": "Qwen/Qwen2.5-72B-Instruct", // 模型名(对应OneAPI中渠道的模型名)
      "name": "Qwen2.5-72B-Instruct", // 模型别名
      "maxContext": 32000, // 最大上下文
      "maxResponse": 4000, // 最大回复
      "quoteMaxToken": 30000, // 最大引用内容
      "maxTemperature": 1, // 最大温度
      "charsPointsPrice": 0, // n积分/1k token（商业版）
      "censor": false, // 是否开启敏感校验（商业版）
      "vision": false, // 是否支持图片输入
      "datasetProcess": true, // 是否设置为文本理解模型（QA），务必保证至少有一个为true，否则知识库会报错
      "usedInClassify": true, // 是否用于问题分类（务必保证至少有一个为true）
      "usedInExtractFields": true, // 是否用于内容提取（务必保证至少有一个为true）
      "usedInToolCall": true, // 是否用于工具调用（务必保证至少有一个为true）
      "usedInQueryExtension": true, // 是否用于问题优化（务必保证至少有一个为true）
      "toolChoice": true, // 是否支持工具选择（分类，内容提取，工具调用会用到。）
      "functionCall": false, // 是否支持函数调用（分类，内容提取，工具调用会用到。会优先使用 toolChoice，如果为false，则使用 functionCall，如果仍为 false，则使用提示词模式）
      "customCQPrompt": "", // 自定义文本分类提示词（不支持工具和函数调用的模型
      "customExtractPrompt": "", // 自定义内容提取提示词
      "defaultSystemChatPrompt": "", // 对话默认携带的系统提示词
      "defaultConfig": {}, // 请求API时，挟带一些默认配置（比如 GLM4 的 top_p）
      "fieldMap": {} // 字段映射（o1 模型需要把 max_tokens 映射为 max_completion_tokens）
    },
    {
      "provider": "Other",
      "model": "Qwen/Qwen2-VL-72B-Instruct",
      "name": "Qwen2-VL-72B-Instruct",
      "maxContext": 32000,
      "maxResponse": 4000,
      "quoteMaxToken": 30000,
      "maxTemperature": 1,
      "charsPointsPrice": 0,
      "censor": false,
      "vision": true,
      "datasetProcess": false,
      "usedInClassify": false,
      "usedInExtractFields": false,
      "usedInToolCall": false,
      "usedInQueryExtension": false,
      "toolChoice": false,
      "functionCall": false,
      "customCQPrompt": "",
      "customExtractPrompt": "",
      "defaultSystemChatPrompt": "",
      "defaultConfig": {}
    }
  ],
  "vectorModels": [
    {
      "provider": "Other",
      "model": "Pro/BAAI/bge-m3",
      "name": "Pro/BAAI/bge-m3",
      "charsPointsPrice": 0,
      "defaultToken": 512,
      "maxToken": 5000,
      "weight": 100
    }
  ],
  "reRankModels": [
    {
        "model": "BAAI/bge-reranker-v2-m3", // 这里的model需要对应 siliconflow 的模型名
        "name": "BAAI/bge-reranker-v2-m3",
        "requestUrl": "https://api.siliconflow.cn/v1/rerank",
        "requestAuth": "siliconflow 上申请的 key"
    }
  ],
  "audioSpeechModels": [
    {
        "model": "fishaudio/fish-speech-1.5",
        "name": "fish-speech-1.5",
        "voices": [
            {
                "label": "fish-alex",
                "value": "fishaudio/fish-speech-1.5:alex",
                "bufferId": "fish-alex"
            },
            {
                "label": "fish-anna",
                "value": "fishaudio/fish-speech-1.5:anna",
                "bufferId": "fish-anna"
            },
            {
                "label": "fish-bella",
                "value": "fishaudio/fish-speech-1.5:bella",
                "bufferId": "fish-bella"
            },
            {
                "label": "fish-benjamin",
                "value": "fishaudio/fish-speech-1.5:benjamin",
                "bufferId": "fish-benjamin"
            },
            {
                "label": "fish-charles",
                "value": "fishaudio/fish-speech-1.5:charles",
                "bufferId": "fish-charles"
            },
            {
                "label": "fish-claire",
                "value": "fishaudio/fish-speech-1.5:claire",
                "bufferId": "fish-claire"
            },
            {
                "label": "fish-david",
                "value": "fishaudio/fish-speech-1.5:david",
                "bufferId": "fish-david"
            },
            {
                "label": "fish-diana",
                "value": "fishaudio/fish-speech-1.5:diana",
                "bufferId": "fish-diana"
            }
        ]
    }
  ],
  "whisperModel": {
    "model": "FunAudioLLM/SenseVoiceSmall",
    "name": "SenseVoiceSmall",
    "charsPointsPrice": 0
  }
}
```

随便新建一个简易应用，选择对应模型，并开启图片上传后进行测试：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-68.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-70.png) |

可以看到，72B 的模型，性能还是非常快的，这要是本地没几个 4090，不说配置环境，输出怕都要 30s 了。

新建一个知识库（由于只配置了一个向量模型，页面上不会展示向量模型选择）

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-72.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-71.png) |

导入本地文件，直接选择文件，然后一路下一步即可。79 个索引，大概花了 20s 的时间就完成了。现在我们去测试一下知识库问答。

首先回到我们刚创建的应用，选择知识库，调整一下参数后即可开始对话：

|                                                                                             |                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-73.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-75.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-76.png) |

对话完成后，点击底部的引用，可以查看引用详情，同时可以看到具体的检索和重排得分：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-77.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-78.png) |

继续在刚刚的应用中，左侧配置中找到语音播放，点击后可以从弹窗中选择语音模型，并进行试听：

![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-79.png)

继续在刚刚的应用中，左侧配置中找到语音输入，点击后可以从弹窗中开启语言输入

![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-80.png)

开启后，对话输入框中，会增加一个话筒的图标，点击可进行语音输入：

|                                                                                             |                                                                                             |
| ------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------- |
| ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-81.png) | ![alt text](https://cdn.jsdelivr.net/gh/yangchuansheng/fastgpt-imgs@main/imgs/image-82.png) |

如果你想快速的体验开源模型或者快速的使用 FastGPT，不想在不同服务商申请各类 Api Key，那么可以选择 SiliconFlow 的模型先进行快速体验。

如果你决定未来私有化部署模型和 FastGPT，前期可通过 SiliconFlow 进行测试验证，后期再进行硬件采购，减少 POC 时间和成本。

**Examples:**

Example 1 (unknown):
```unknown
## 3. 修改 FastGPT 配置文件

我们选取 SiliconFlow 中的模型作为 FastGPT 配置。这里配置了 `Qwen2.5 72b` 的纯语言和视觉模型；选择 `bge-m3` 作为向量模型；选择 `bge-reranker-v2-m3` 作为重排模型。选择 `fish-speech-1.5` 作为语音模型；选择 `SenseVoiceSmall` 作为语音输入模型。

注意：ReRank 模型仍需配置一次 Api Key
```

---

## 指定硅基流动的 API Key

**URL:** llms-txt#指定硅基流动的-api-key

export SILICON_API_KEY=上面流程中复制的密钥

---

## NextChat

**URL:** llms-txt#nextchat

**Contents:**
- 1. 获取 API Key
- 2. 部署 NextChat

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-nextchat

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

访问[ NextChat ](https://app.nextchat.dev/)官网，或者本地安装[ ChatGPT-Next-Web ](https://github.com/ChatGPTNextWeb/ChatGPT-Next-Web)之后：

1. 点击页面左下角的“设置”按钮
2. 找到其中的“自定义接口”选项并选中
3. 填入参数：

* **接口地址：** [https://api.siliconflow.cn](https://api.siliconflow.cn)
* **API Key：** 输入“ API 密钥页签 ”生成的 API Key 并填入“自定义模型名”和“模型（ model ）”

其它自定义模型名可以在 [https://docs.siliconflow.cn/api-reference/chat-completions/chat-completions](https://docs.siliconflow.cn/api-reference/chat-completions/chat-completions) 中查找

---

## NoBase

**URL:** llms-txt#nobase

**Contents:**
- 硅基流动 AI 模型配置教程

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-nobase

NoBase 是寻安科技推出的一站式后端 API 集成平台，旨在给用户提供无需编写后端代码，一键复制接口地址即可获取数据，通过后台管理系统实时查看运营数据的高效体验。[官网直达](https://nobase.cn/)

NoBase 集成了多个功能系统的 API 接口：

* 应用系统、用户（登陆、注册等）系统
* 卡密（兑换码）、邮箱、论坛系统
* AI 大模型对话接口，角色扮演（提示词智能体）系统
* 云文档（文本、JSON、网页）系统
* 更多系统接口解锁中···

* 打开主页找到 AI系统 -> 系统配置。

* 接口提供商选择硅基流动,点击下方提示进入硅基流动。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=88af1361a4807c3f9e21d26bded49e7a" data-og-width="1914" width="1914" data-og-height="958" height="958" data-path="images/usercases/nobase/1.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=9a9a72e6e663bc71c3d97531f75d550a 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=5255d99e1af196c8be18192ee7ba6511 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c1d59e0f1ede1456d8ddeeb64f8be19f 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=65e65e365c676a409db239609246624f 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6e6c9cc880cb6149fe2f9a5bf8876e96 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/1.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=4216c1446f69333af086c7f1a3f63912 2500w" />
</Frame>

* 打开硅基流动后，如果你还未登陆请先登录，进入硅基流动平台的 API 密钥管理页面。
* 如果下方没有 API 密钥请先点击上方蓝色按钮“新建 API 密钥”，完成之后点击密钥进行复制。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=ca37e43fbece1cb61c7ee895ae090a79" data-og-width="1914" width="1914" data-og-height="971" height="971" data-path="images/usercases/nobase/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=812913ff94125527f0e55c6f0c158af7 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=a17969c82493d6a30b09a12b589c37f2 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=7c367c95be8e2cbb5f59eb997650e7f2 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c54c2951859a15b17bf3e8bc6435a0f4 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=11b4841995853017442ed1f60743cfba 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/2.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=da75118d4a582f2981143ad5ef7f4579 2500w" />
</Frame>

* 回到 NoBase 粘贴 APIKEY（API密钥）,然后点击右边的验证并加载模型按钮即可展示模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=3f8d0652d1a6482562d41b67644f12fc" data-og-width="1280" width="1280" data-og-height="646" height="646" data-path="images/usercases/nobase/3.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=e586c0dfb4a79874c2c442b698f50e06 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=48a5e90b0ede259cd94ae0ac4cfde7be 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=2c7c3f2c257b29dcb4040ee683326a21 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=1f5e53dd950ee3f63c1182dc5f33fe96 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=04feded542b4b26b81a7ddc36f23b84d 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/3.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=bdbb342c6a0137cd4c227f02f80a7240 2500w" />
</Frame>

* 验证完成后可以看到可以选择硅基流动的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=0a154c421021364a8e5dab8f036d46f6" data-og-width="1918" width="1918" data-og-height="959" height="959" data-path="images/usercases/nobase/4.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=716c5b4e96adecb2d7a5dfbcc1a1f0f6 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=24404859a0bb5e186eada34dfb82f3db 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=50a97a9b26dbd9a4a81dbd40abb91955 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=34eaae308dfb74932b5269c59251a9c5 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=c88e0a18c14f4ff3fe109fff98212171 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/4.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=89064ade756dcf81dab9c0d82800c4ed 2500w" />
</Frame>

* 点击保存完成 AI 接口配置后根据文档请求接口，可以看到成功请求硅基流动的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=b3e6cfe9ae35667d348327c87f635eb4" data-og-width="1919" width="1919" data-og-height="965" height="965" data-path="images/usercases/nobase/5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=539e01aafa9872ac8143922be187901f 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=109153ec2e641221f1a8654ac54c9de0 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6364f8b5b1902d63f169d81826ebbb24 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=02d4f0bae4637c1a48cb62e6146284c8 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=ff5198ef557d5b3281b6034f6ef403e0 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/5.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=9188b13be40b4114dd0314b0f64fd0cc 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=41997a1437bac6ccf1f20e1c1aef7359" data-og-width="1544" width="1544" data-og-height="917" height="917" data-path="images/usercases/nobase/6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=280&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=3426df6ab6dda81fbc90c08fd9883cae 280w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=560&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=1eede5dedff1dba52ed5de319bee218d 560w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=840&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=b9821cb9aae08030f39426201668b32a 840w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=1100&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=d2bc0c0517bc0d944ba97d41aaca0462 1100w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=1650&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=be8f58b9fd1d561425c84a5d5457d838 1650w, https://mintcdn.com/siliconflow-37161621/rKA6cTOTHeFjhysv/images/usercases/nobase/6.png?w=2500&fit=max&auto=format&n=rKA6cTOTHeFjhysv&q=85&s=6756d671fe845206e6a2af150eff6e94 2500w" />
</Frame>

> 如有使用上的疑问，可加入 [天使用户群](https://qm.qq.com/q/TO50m57Nok) 反馈。

---

## Sider

**URL:** llms-txt#sider

**Contents:**
- 1. 获取 API Key
- 2. 在 Sider 中使用 SiliconFlow 语言模型系列

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-sider

作为 2023 年度 “Chrome 年度精选插件”，Sider 获得了 50K+ “5星好评”，并有 6+百万 的活跃用户。Sider 浏览器插件主要解决：

* Sider（ChatGPT 侧边栏）是您有用的人工智能助手，您可以在浏览任何网站时使用它。

<Note>开发者可以打开 [Sider官网](https://sider.ai/zh-CN/) 来使用 Sider 应用。</Note>
<Note> Sider 为满足软件开发者的需求，提供了 OpenAI API的兼容模型注册方式，以便大家可以更加便利的使用大家想要的模型。</Note>
<Note> 作为集合顶尖大模型的一站式云服务平台，SiliconFlow 致力于为开发者提供更快、更便宜、更全面、体验更丝滑的模型API。 </Note>
那么怎么在 Sider 中使用 SiliconFlow 呢？

1. 打开 SiliconFlow [官网](https://cloud.siliconflow.cn/) 并注册账号（如果注册过，直接登录即可）。
2. 完成注册后，打开[API密钥](https://cloud.siliconflow.cn/account/ak) ，创建新的 API Key，点击密钥进行复制，以备后续使用。

## 2. 在 Sider 中使用 SiliconFlow 语言模型系列

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=aff9a01f92463d2d489ec42dc53693c0" data-og-width="2448" width="2448" data-og-height="1874" height="1874" data-path="images/usercases/sider/sider.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=16c231afe6f32639025495688c064f38 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=20f34173720236fcdfa0135ec0be8845 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f8a58ece6e25d78d9d272eea215760c7 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3f3bce3ca7135782bed179b87865c26f 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=69d2ffdd0da9e9f6423073051795028a 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/sider/sider.jpeg?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=60b36bb51482540c18163c22a8899994 2500w" />
</Frame>

---

## Trae

**URL:** llms-txt#trae

**Contents:**
- 切换模型
- 添加硅基流动模型

Source: https://docs.siliconflow.cn/cn/usercases/use-siliconcloud-in-trae

[Trae](https://www.trae.com.cn/) 是字节推出的首个 AI IDE，Trae 预置了一系列业内表现比较出色的模型，你可以直接切换不同的模型进行使用。此外，Trae Chat 模式还支持通过 API 密钥（API Key）接入硅基流动的模型资源，从而满足个性化的需求。

在输入框的右下角，点击当前模型名称，打开模型列表，然后选择你想使用的模型。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=1747650c77c13bf0b8006fd8af22c824" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-1.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=23b7f373743c254efeccccfe568f51aa 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=5576a62497e6a0ccf8d2ec4caafc81e8 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3ef68dcd7e5998afcee62cb73888ccdf 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=2b4c0e5e23c85db8db096af1931e0f3f 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ec4fe5e502ebd72e611188afeec24ea6 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-1.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=f23f19895565051f292aa8981cdd7037 2500w" />
</Frame>

各个模型的能力不同，你可以将鼠标悬浮至模型名称上，然后查看该模型支持的能力。

1、前往 **头像** > **设置** > **Trae AI** > **模型管理**。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=75fb614c651764c033941fd49d216fcf" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-2.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bc83921058771fe48949843ba49d37bf 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6cdb35c08b1472b91535ba8a4c12d390 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0810a8c73574e06ba73ce0059fc964e7 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=27a626f72e241e77068fcbe4f82cdb68 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0b21a644d01a13fade90ee77cc7613eb 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-2.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c39fa3366018422a0432324008b9fc4c 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=4ff8b03199290acbd5beb2d3e9e8a3b6" data-og-width="1280" width="1280" data-og-height="800" height="800" data-path="images/usercases/trae/trae-3.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c853a0a3b1ba6dc9f34989149353c9df 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=622a0260d94749eb23cb23767fa72658 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=db86acd95991542b194d689a02a45e76 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e51456c448ee7fe2db51e6e61003ea60 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=94cc96a5302a34495d2bb51f1b6e4292 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-3.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=6909f884f89ee93abbd9bbbed7d21216 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8c47b6803454d3b6e1ea19c87c3e7d95" data-og-width="1280" width="1280" data-og-height="852" height="852" data-path="images/usercases/trae/trae-4.PNG" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=336f5b64b91cc1328b97f9c10793b950 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0e43511b7ee63c3d98260e19d996916e 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=7237c8f277cdfbba9cc8490a25082366 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=3a4203efa11390a0aa1e9f8d5d49e177 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e64913198173041f61cfee7e2bceaed5 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-4.PNG?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=340334c63324d4c7162f6e3d9ebd30dc 2500w" />
</Frame>

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=c6ad83c31b0465f0edaab857ccca73c4" data-og-width="1280" width="1280" data-og-height="855" height="855" data-path="images/usercases/trae/trae-5.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=22fa0d68b0d645a66a4bed5342415339 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=480fb56b25b903a8a40450745e974982 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=67e2c593aefc419a8bff8bc01546790a 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=680825836b37b666f7769138c1f4476c 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8cf6f666f7005f009a9acbdd42ffdd0c 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-5.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=bccec004763dcbfb22cc5cc577e8e2a4 2500w" />
</Frame>

￮ 直接从列表中选择 Trae 为每个服务商预置的模型（均为默认版本）。

￮ 若你希望使用其他模型或使用特定版本的模型，点击列表中的 **使用其他模型**，然后在输入框中填写模型 ID。

点击 **获取 API 密钥** 按钮，Trae 会为你打开硅基流动的 API 密钥配置页面。（若未注册/登录对应网站，需先完成注册/登录动作）

进入页面后创建新的 API Key，点击密钥进行复制。

Trae 将调用服务商的接口来检测 API 密钥是否有效。可能的结果如下：

￮ 若连接失败，**添加模型** 窗口中展示错误信息和服务商返回的错误日志，你可以参考这些信息排查问题。

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=8d6869098e6312ab84c0251ed93027ef" data-og-width="2388" width="2388" data-og-height="1568" height="1568" data-path="images/usercases/trae/trae-6.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb3a7e209bb4c86580ee2ba084d21bd3 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a94650086bf8453f877664a8bd3b7a74 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=dba3d61b5e4da0f83e97a3cf13d3d2ad 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=e82555e438618d7146f9c0b476b3b0e8 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fb9012cdfa33ee94fd719233c688c41b 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/trae/trae-6.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=ef49052bec12871dcfbb50c5c63d2ca5 2500w" />
</Frame>

| **编号** | **操作类型** | **说明**                                                                       |
| ------ | -------- | ---------------------------------------------------------------------------- |
| 1      | 编辑模型     | 点击 **编辑** 图标，然后在弹窗中修改服务商、模型名称、API 密钥等信息。                                     |
| 2      | 删除模型     | 点击 **删除** 图标，然后在弹窗中二次确认。删除后，当前模型将被从列表里移除，不可被继续使用。                            |
| 3      | 启用/禁用模型  | 若你不希望删除模型，但在一段时间内无需使用这个模型，你可以禁用该模型。被禁用的模型将保留在设置页面的列表中，但不会出现在 AI 对话框的模型选择列表中。 |

---

## 这个url固定填写，无需改动

**URL:** llms-txt#这个url固定填写，无需改动

translate.service.openai.url=https://api.siliconflow.cn/v1/chat/completions

---

## 硅基流动的 API 密钥，你上一步获取到的，填到这里

**URL:** llms-txt#硅基流动的-api-密钥，你上一步获取到的，填到这里

translate.service.openai.key=sk-kqpnpfhlikgacrmdab2946d28eb00ede7acd9b3axfiIadf4P81

---

## 进行大模型API调用线程池的程数。不懂可设置100即可。此参数的具体说明可参考 http://translate.zvo.cn/396728.html

**URL:** llms-txt#进行大模型api调用线程池的程数。不懂可设置100即可。此参数的具体说明可参考-http://translate.zvo.cn/396728.html

**Contents:**
  - 使用
  - 日志查看

translate.service.thread.number=100

/mnt/service/start.sh

curl --request POST \
  --url https://siliconflow.zvo.cn/translate.json \
  --header 'content-type: application/x-www-form-urlencoded' \
  --data to=english \
  --data 'text=["你好，世界","让我们探索星辰大海"]'

<script src="https://cdn.staticfile.net/translate.js/3.15.6/translate.min.js"></script>
<script>
translate.service.use('translate.service'); //设置采用私有部署的翻译通道，相关说明参考 https://translate.zvo.cn/4081.html
translate.request.api.host='http://121.121.121.121/'; //将这里面的ip地址换成你服务器的ip，注意开头，及结尾还有个 / 别拉下
translate.execute();//进行翻译 
</script>

{"time":"00:40:59","originalText":"按钮切换语言:","resultText":"Button switch language:","to":"english","useTime":583,"score":96}
{"time":"00:40:59","originalText":"语言切换示例：","resultText":"Language Switching Example:","to":"english","useTime":482,"score":96}
{"time":"00:40:59","originalText":"你好","resultText":"Hello","to":"english","useTime":546,"score":96}

{"method":"translate.json","size":4,"ip":"192.168.31.95","domain":"192.168.31.95","memoryCacheHitsSize":5,"time":"2025-03-19 10:22:56","memoryCacheHitsNumber":1,"to":"english"}
{"fileCache":"1845bbcbd9e600fab184b346d82042a9_english.txt","method":"translate.json","size":4,"ip":"192.168.31.95","domain":"192.168.31.95","time":"2025-03-19 10:26:56","to":"english"}
```

* **method** 当前请求的是哪个接口。比如 translate.json 则是请求的文本翻译 API 接口； language.json 则是请求的获取当前所支持的语言列表接口
* **fileCache** 针对 translate.json 翻译接口的请求，如果有命中文件缓存，则有这个参数，其值是 文件缓存的名字，它是在 `/mnt/service/cache/` 内的
* **originalSize** 针对 translate.json 翻译接口的请求，记录当前翻译的字符数（原文的字符数，非译文）
* **size** 针对 translate.json 翻译接口的请求，记录当前翻译的字符数（译文的字符数，非原文）
* **ip** 请求来源的 ip
* **domain** 针对 translate.json 翻译接口的请求，如果是网站使用了 translate.js ，那这个则是这个网站的域名（它是自动获取到的）
* **time** 触发的时间
* **to** 针对 translate.json 翻译接口的请求，翻译为什么语种
* **key** 针对 translate.json 翻译接口的请求，如果是你给对方通过 domain.json 配置设置的文本翻译 key，那这个就是记录的 key。
* **memoryCacheHitsNumber** 针对 translate.json 翻译接口的请求，如果有命中内存缓存，这里是记录命中内存缓存的条数（translate.json 支持同时翻译多条）
* **memoryCacheHitsSize** 针对 translate.json 翻译接口的请求，如果有命中内存缓存，这里是记录命中内存缓存的字符数（译文的字符数，非原文）

**Examples:**

Example 1 (unknown):
```unknown
当然，还有更多的配置方式可以解锁更高的能力，这些刚部署初期你可以忽略，熟悉了可以研究：

* [翻译精准度效验及自动修复](https://translate.zvo.cn/411064.html)
* [配置多翻译通道支持的语种分流策略](https://translate.zvo.cn/426176.html)
* [配置翻译API接口的流量控制](https://translate.zvo.cn/413975.html)
* [配置备用翻译通道](https://translate.zvo.cn/404947.html)
* ...

#### 5. 重启项目

操作完毕后，重启 translate.service 服务，执行重启命令 :
```

Example 2 (unknown):
```unknown
#### 6. 访问测试

直接访问你的服务器 ip，即可看到效果：

<Frame>
  <img src="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=0128421f1be0331c8362bdffc36be52b" data-og-width="341" width="341" data-og-height="185" height="185" data-path="images/usercases/translate-js/2.png" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=280&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=11f19bf6d0a349ebf5162440057187e9 280w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=560&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a57516d48050d8a2b173966f0dfe0782 560w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=840&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=fb11b38c1035ede727c397e2d5a4398f 840w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=1100&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=eb09d28fd689ff655e887a40427a9863 1100w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=1650&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=a1e30b5adadea0c08d01ab499ebe34e4 1650w, https://mintcdn.com/siliconflow-37161621/rTllRSaJ4Y2ZHvoY/images/usercases/translate-js/2.png?w=2500&fit=max&auto=format&n=rTllRSaJ4Y2ZHvoY&q=85&s=32f99cfd7fb79be0ab1ebcc26a067bae 2500w" />
</Frame>

随便选个语种切换一下试试，切换后“你好，世界”能被翻译，说明已接入成功，可以正常使用了。

### 使用

#### 文本翻译 API 接口

它以 [硅基流动](https://cloud.siliconflow.cn/i/64MyJQtM)  平台的大模型算力作为基础支撑，通过 [translate.service](https://gitee.com/mail_osc/translate) 作为中间调度。
你完全不需要去了解 大模型 是什么以及怎么使用，给你暴露出标准的API翻译接口进行使用。

**请求 URL** ：[http://你的服务器 ip/translate.json](http://api.zvo.cn/translate/service/20230807/translate.json.html)
**请求方式** ：POST
**请求方式** ：POST
**请求参数** ：

* **to** 将文本翻译为什么语种。可传入如 english 更多语种可访问 [http://你服务器的 ip/language.json](http://api.zvo.cn/translate/service/20230807/language.json.html) 就能看到
* **text** 需要翻译的语言。格式如 `["你好","世界"]` 它是 json 数组格式，支持一次翻译多个不同的文本，每个文本可以分别是不同的语言。
  **响应示例** ：
  `{"result":1,"info":"success","to":"english","text":["Hello","World"]}`

注意，header 头的 Content-Type 要么不设置，如果设置的话值是 application/x-www-form-urlencoded

**curl 翻译示例：**

为了方便理解上面的 API 接口使用，这里给出了一个 curl 请求的示例，另外这个示例你也可以直接复制就能运行使用，看到效果
```

Example 3 (unknown):
```unknown
它是开放的，你不需要再去买高额的文本翻译了，硅基流动给你提供免费的，翻译通顺度还更高！
[可点此查看有关文本翻译API接口的详细文档](http://api.zvo.cn/translate/service/20230807/translate.json.html)

#### 网页多语言切换

使用方式为，在网页最末尾，html 结束之前，加入以下代码，一般在页面的最底部就出现了选择语言的 select 切换标签，你可以点击切换语言试试切换效果
```

Example 4 (unknown):
```unknown
如此，翻译请求接口就会走您自己服务器了。有关这个手动指定翻译接口的详细说明，可参考： [http://translate.zvo.cn/4068.html](https://gitee.com/link?target=http%3A%2F%2Ftranslate.zvo.cn%2F4068.html)

另外 translate.js 这个 js 文件你可以自己下载下来放到你自己项目里使用，它没有任何别的依赖，是标准的原生 JavaScript 。而且 translate.js 是完全开源的，你可以从 [https://raw.githubusercontent.com/xnx3/translate/refs/heads/master/translate.js/translate.js](https://gitee.com/link?target=https%3A%2F%2Fraw.githubusercontent.com%2Fxnx3%2Ftranslate%2Frefs%2Fheads%2Fmaster%2Ftranslate.js%2Ftranslate.js) 下载最新的 js，放到你项目里进行使用。

他的原理是直接扫描你网页的 dom 元素进行自动分析识别，然后将文本集中化进行翻译。也就是你要讲这个 translate.execute(); 这行要放在最底部，就是因为上面的渲染完了在执行它，可以直接触发整个页面的翻译。

### 日志查看

你可以从服务器中查看相关日志情况。
日志存放于 /mnt/service/logs/ 目录下

#### 文本翻译日志

openai\_yyyy-MM-dd.log 是硅基流动通过openai接口调用大模型进行文本翻译的日志

比如： `openai_2025-05-17.log`
yyyy-MM-dd 是当前的年月日，它按照日期每天都会创建一个日志文件。
它记录了你所有文本翻译的原文、译文、进行时间、翻译结果审查得分、是否启用了修复机制 等
它每行都是一个文本翻译记录。
示例：
```

---

## Round 2

**URL:** llms-txt#round-2

**Contents:**
- 5. 注意事项
- 6. 常见问题

messages.append({"role": "assistant", "content": content})
messages.append({'role': 'user', 'content': "继续"})
response = client.chat.completions.create(
    model="Pro/deepseek-ai/DeepSeek-R1",
    messages=messages,
    stream=False
)
```

* API 密钥：请确保使用正确的 API 密钥进行身份验证。
* 流式输出：流式输出适用于需要逐步接收响应的场景，而非流式输出则适用于一次性获取完整响应的场景。

请访问 [SiliconFlow](https://cloud.siliconflow.cn/) 注册并获取 API 密钥。
* 如何处理超长文本？

可以通过调整 max\_tokens 参数来控制输出的长度，但请注意最大长度为 16K。

---

## 文本转语音模型

**URL:** llms-txt#文本转语音模型

**Contents:**
- 1. 使用场景
- 2. API 使用指南
  - 2.1 系统预置音色：
  - 2.2 用户预置音色：

Source: https://docs.siliconflow.cn/cn/userguide/capabilities/text-to-speech

文本转语音模型（TTS）是一种将文本信息转换为语音输出的 AI 模型。该模型将输入文本内容生成自然流畅、富有表现力的语音，适用于多种应用场景：

* 为博客文章提供音频朗读
* 生成多语言语音内容
* 支持实时流媒体音频输出

* 端点：/audio/speech，具体使用可参考[api文档](https://docs.siliconflow.cn/api-reference/audio/create-speech)
* 主要请求参数：
  * model：用于语音合成的模型，支持的[模型列表](/capabilities/text-to-speech#3)。
  * input：待转换为音频的文本内容。
  * voice：参考音色，支持[系统预置音色](/capabilities/text-to-speech#2-1)、[用户预置音色](/capabilities/text-to-speech#2-2)、[用户动态音色](/capabilities/text-to-speech#2-3)。
    详细参数请参考：[创建文本转语音请求](/api-reference/audio/create-speech)。
  * speed：可以控制音频速度，float类型，默认值是1.0，可选范围是\[0.25,4.0]；
  * gain：音频增益，单位dB，可以控制音频声音大小，float类型，默认值是0.0，可选范围是\[-10,10]；
  * response\_format：控制输出格式，支持 mp3、opus、wav 和 pcm 格式。在选择不同的输出格式时，输出的采样率也会有所不同。
  * sample\_rate：可以控制输出采样率，对于不同的视频输出类型，默认值和可取值范围均不同，具体如下：
    * opus: 目前只支持48000hz
    * wav, pcm: 支持 (8000, 16000, 24000, 32000, 44100), 默认44100
    * mp3: 支持(32000, 44100), 默认44100

<Note>注意：输入内容不要加空格，参考音频要小于30s</Note>

* 男生音色：
  * 沉稳男声: [alex](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Alex.mp3)
  * 低沉男声: [benjamin](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Benjamin.mp3)
  * 磁性男声: [charles](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Charles.mp3)
  * 欢快男声: [david](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-David.mp3)

* 女生音色：
  * 沉稳女声: [anna](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Anna.mp3)
  * 激情女声: [bella](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Bella.mp3)
  * 温柔女声: [claire](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Claire.mp3)
  * 欢快女声: [diana](https://sf-maas-uat-prod.oss-cn-shanghai.aliyuncs.com/voice_template/fish_audio-Diana.mp3)

[在线试听](https://soundcloud.com/siliconcloud/sets/siliconcloud-online-voice)上述音频。

在请求中[使用系统预置音色](/capabilities/text-to-speech#5-1)。
在使用对应的系统预置音色时，需要在前面加上模型名称，比如：

`FunAudioLLM/CosyVoice2-0.5B:alex` 表示 `FunAudioLLM/CosyVoice2-0.5B` 模型下的 `alex` 音色。

<Note>注意：使用用户预置音色，需要进行实名认证。</Note>

#### 2.2.1 通过 `base64` 编码格式上传用户预置音色

```python  theme={null}
import requests
import json

url = "https://api.siliconflow.cn/v1/uploads/audio/voice"
headers = {
    "Authorization": "Bearer your-api-key", # 从 https://cloud.siliconflow.cn/account/ak 获取
    "Content-Type": "application/json"
}
data = {
    "model": "FunAudioLLM/CosyVoice2-0.5B", # 模型名称
    "customName": "your-voice-name", # 用户自定义的音频名称
    "audio": "data:audio/mpeg;base64,SUQzBAAAAAAAIlRTU0UAAAAOAAADTGF2ZjYxLjcuMTAwAAAAAAAAAAAAAAD/40DAAAAAAAAAAAAASW5mbwAAAA8AAAAWAAAJywAfHx8fKioqKio1NTU1Pz8/Pz9KSkpKVVVVVVVfX19fampqamp1dXV1f39/f3+KioqKlZWVlZWfn5+fn6qqqqq1tbW1tb+/v7/KysrKytXV1dXf39/f3+rq6ur19fX19f////", # 参考音频的 base64 编码
    "text": "在一无所知中, 梦里的一天结束了，一个新的轮回便会开始" # 参考音频的文字内容
}

response = requests.post(url, headers=headers, data=json.dumps(data))

---

## 获取文件上传后的id

**URL:** llms-txt#获取文件上传后的id

**Contents:**
  - 2.3 创建批量推理任务
  - 2.4 检查批量推理状态
  - 2.5 取消正在进行中的批量推理任务
  - 2.6 获得批量推理结果
  - 2.7 获取所有批量推理列表
  - 2.8 批量推理任务超时（expired）
- 3. 支持模型列表
- 4. 输入限制：
- 5. 费用说明

file_id = batch_input_file.data['id']
print(file_id)
python  theme={null}
from openai import OpenAI

client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1
)

batch_input_file_id = "file-abc123"
client.batches.create(
    input_file_id=batch_input_file_id,
    endpoint="/v1/chat/completions",
    completion_window="24h",
    metadata={
        "description": "nightly eval job"
    },
    extra_body={"replace":{"model": "deepseek-ai/DeepSeek-V3"}}
)

python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)

batch = client.batches.retrieve("batch_abc123")
print(batch)
json  theme={null}
{
  "id": "batch_abc123",
  "object": "batch",
  "endpoint": "/v1/chat/completions",
  "errors": null,
  "input_file_id": "file-abc123",
  "completion_window": "24h",
  "status": "validating",
  "output_file_id": null,
  "error_file_id": null,
  "created_at": 1714508499,
  "in_progress_at": null,
  "expires_at": 1714536634,
  "completed_at": null,
  "failed_at": null,
  "expired_at": null,
  "request_counts": {
    "total": 0,
    "completed": 0,
    "failed": 0
  },
  "metadata": null
}
python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)
client.batches.cancel("batch_abc123")
python  theme={null}
from openai import OpenAI
client = OpenAI(
    api_key="YOUR_API_KEY", 
    base_url="https://api.siliconflow.cn/v1"
)
response = client.batches.list().data
print(response)
json  theme={null}
{"id": "batch_req_123", "custom_id": "request-3", "response": null, "error": {"code": "batch_expired", "message": "This request could not be executed before the completion window expired."}}
{"id": "batch_req_123", "custom_id": "request-7", "response": null, "error": {"code": "batch_expired", "message": "This request could not be executed before the completion window expired."}}
```

目前仅支持端点`/v1/chat/completions`，且支持模型如下：

* deepseek-ai/DeepSeek-V3
* deepseek-ai/DeepSeek-R1
* Qwen/QwQ-32B
* deepseek-ai/DeepSeek-V3.1-Terminus
* moonshotai/Kimi-K2-Instruct-0905

Batch Job 输入限制与现有的按模型速率限制是分开的，参考如下条件：

1. 每 batch 限制： 单个 batch 对应的输入文件的大小最大`1 G`。

说明：Batch Job 的请求不影响用户在线推理服务的 Rate Limits 使用。因此使用批量 API 不会消耗标准请求中的（用户，模型）维度的 Rate Limits的Request 或者 tokens 限制。

Batch 只能使用`充值余额`进行支付，具体价格如下：

> SiliconFlow 平台推理模型价格表（单位：￥/百万 Tokens）

| 模型名称                               | 实时推理 - 输入 | 实时推理 - 输出 | 批量推理 - 输入 | 批量推理 - 输出 |
| ---------------------------------- | --------- | --------- | --------- | --------- |
| DeepSeek-R1                        | ¥4        | ¥16       | ¥2        | ¥8        |
| DeepSeek-V3                        | ¥2        | ¥8        | ¥1        | ¥4        |
| Qwen/QwQ-32B                       | ¥1        | ¥4        | ¥0.5      | ¥2        |
| deepseek-ai/DeepSeek-V3.1-Terminus | ¥4        | ¥12       | ¥2        | ¥6        |
| moonshotai/Kimi-K2-Instruct-0905   | ¥4        | ¥16       | ¥2        | ¥8        |

<Note> 注：如有大规模使用需求，欢迎 [联系我们](https://siliconflow.feishu.cn/share/base/form/shrcnxIMbsUUDf7xjrRIjenRYoh?hide_user_id=1\&prefill_user_id=sfd1482i3mkkq07mnvc510) 了解专属方案。 </Note>

**Examples:**

Example 1 (unknown):
```unknown
这里需要记录下返回结果中的id，作为后面创建batch时候的请求参数。

### 2.3 创建批量推理任务

成功上传输入文件后，使用输入文件对象的 ID 创建批量推理任务，并设置任务参数。

* 对于对话模型，请求端点为`/v1/chat/completions`；
* 完成窗口目前支持设置`24 ～ 336 小时（14 ✕ 24 小时）`；
* 我们建议您通过`extra_body`设置任务需要使用的推理模型，如：`extra_body={"replace":{"model": "deepseek-ai/DeepSeek-V3"}}`，除非您的输入文件符合`OpenAI`的要求，文件中的每一行都具有相同的`model`；
* 如果您的`extra_body`中设置的模型，与输入文件中的`model`不一致，则任务实际使用模型以`extra_body`为准；
* `metadata`参数可以用于备注一些额外的任务信息，如任务描述等。
  以下为使用 OpenAI SDK 调用 SiliconFlow 输入文件的示例，input\_file\_id 从上一步完成上传的文件对象中获取。
```

Example 2 (unknown):
```unknown
该请求将创建一个批量推理任务，并返回任务的状态信息。

### 2.4 检查批量推理状态

您可以随时检查批量处理任务的状态，代码示例如下：
```

Example 3 (unknown):
```unknown
返回的推理任务状态信息如下：
```

Example 4 (unknown):
```unknown
其中status包含以下几种状态：

* **in\_queue**： 批量推理任务在排队中
* **in\_progress**： 批量推理任务正在进行中
* **finalizing**： 批量推理任务已完成，正在准备结果
* **completed**： 批量推理任务已完成，结果已准备就绪
* **expired**： 批量推理任务没有在预期完成时间内执行完成
* **cancelling**： 批量推理任务取消中（等待执行中结果返回）
* **cancelled**： 批量推理任务已取消

### 2.5 取消正在进行中的批量推理任务

如有必要，您可以取消正在进行的批量处理任务。批量处理任务状态将变为`cancelling`，直到在途的请求完成，之后该任务的状态将变为`cancelled`。
```

---

## FIM 补全

**URL:** llms-txt#fim-补全

**Contents:**
- 1. 使用场景
- 2. 使用方式
  - 2.1 在 chat/completions 接口中使用
  - 2.2 在 completions 接口中使用
- 3. 支持模型列表
- 4. 使用示例
  - 4.1 基于 OpenAI 的 chat.completions 接口使用FIM补全：

Source: https://docs.siliconflow.cn/cn/userguide/guides/fim

FIM (Fill In the Middle) 补全中，用户提供希望输入的前后内容，模型来补全中间的内容，典型用于代码补全、文本中间内容补全等场景中。

### 2.1 在 chat/completions 接口中使用

### 2.2 在 completions 接口中使用

* Deepseek 系列：
  * deepseek-ai/DeepSeek-V2.5
  * Pro/deepseek-ai/DeepSeek-R1
  * deepseek-ai/DeepSeek-R1
  * Pro/deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-32B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-14B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-7B
  * Pro/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B

* Qwen系列：
  * Qwen/Qwen2.5-Coder-7B-Instruct
  * Qwen/Qwen2.5-Coder-32B-Instruct

<Note>注意：支持的模型列表可能会发生变化，请查阅[本文档](/features/fim)了解最新支持的模型列表。</Note>

### 4.1 基于 OpenAI 的 chat.completions 接口使用FIM补全：

```python  theme={null}
client = OpenAI(
    api_key="您的 APIKEY", # 从https://cloud.siliconflow.cn/account/ak获取
    base_url="https://api.siliconflow.cn/v1"
)
 
messages = [
    {"role": "user", "content": "Please write quick sort code"},
]

response = client.chat.completions.create(
    model="deepseek-ai/DeepSeek-V2.5",
    messages=messages,
    extra_body={
            "prefix": f"""
def quick_sort(arr):
    # 基本情况，如果数组长度小于等于 1，则返回数组
    if len(arr) <= 1:
        return arr
    else:
""",
            "suffix": f"""

**Examples:**

Example 1 (unknown):
```unknown
### 2.2 在 completions 接口中使用
```

Example 2 (unknown):
```unknown
## 3. 支持模型列表

* Deepseek 系列：
  * deepseek-ai/DeepSeek-V2.5
  * Pro/deepseek-ai/DeepSeek-R1
  * deepseek-ai/DeepSeek-R1
  * Pro/deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-V3
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-32B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-14B
  * deepseek-ai/DeepSeek-R1-Distill-Qwen-7B
  * Pro/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B

* Qwen系列：
  * Qwen/Qwen2.5-Coder-7B-Instruct
  * Qwen/Qwen2.5-Coder-32B-Instruct

<Note>注意：支持的模型列表可能会发生变化，请查阅[本文档](/features/fim)了解最新支持的模型列表。</Note>

## 4. 使用示例

### 4.1 基于 OpenAI 的 chat.completions 接口使用FIM补全：
```

---

## 使用 WeatherAPI 的天气查询函数

**URL:** llms-txt#使用-weatherapi-的天气查询函数

def get_weather(city: str):
    # 使用 WeatherAPI 的 API 来获取天气信息
    api_key = "您的WeatherAPI APIKEY"  # 替换为你自己的 WeatherAPI APIKEY
    base_url = "http://api.weatherapi.com/v1/current.json"
    params = {
        'key': api_key,
        'q': city,
        'aqi': 'no'  # 不需要空气质量数据
    }
    
    # 调用天气 API
    response = requests.get(base_url, params=params)
    
    if response.status_code == 200:
        data = response.json()
        weather = data['current']['condition']['text']
        temperature = data['current']['temp_c']
        return f"The weather in {city} is {weather} with a temperature of {temperature}°C."
    else:
        return f"Could not retrieve weather information for {city}."

---

## 发送请求并处理 function calling

**URL:** llms-txt#发送请求并处理-function-calling

def function_call_playground(prompt):
    messages = [{'role': 'user', 'content': prompt}]
    
    # 发送请求到 OpenAI API
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools
    )

# 处理 API 返回的工具调用请求
    func1_name = response.choices[0].message.tool_calls[0].function.name
    func1_args = response.choices[0].message.tool_calls[0].function.arguments
    func1_out = eval(f'{func1_name}(**{func1_args})')

# 将结果添加到对话中并返回
    messages.append(response.choices[0].message)
    messages.append({
        'role': 'tool',
        'content': f'{func1_out}',
        'tool_call_id': response.choices[0].message.tool_calls[0].id
    })
    
    # 返回模型响应
    response = client.chat.completions.create(
        model="deepseek-ai/DeepSeek-V2.5",
        messages=messages,
        temperature=0.01,
        top_p=0.95,
        stream=False,
        tools=tools
    )
    
    return response.choices[0].message.content

---

## 产品简介

**URL:** llms-txt#产品简介

**Contents:**
- 1. 产品介绍
- 2. 产品功能
- 3. 产品特性

Source: https://docs.siliconflow.cn/cn/userguide/introduction

* 作为集合顶尖大模型的一站式云服务平台，[SiliconFlow](https://siliconflow.cn/zh-cn/siliconcloud) 致力于为开发者提供更快、更全面、体验更丝滑的模型 API，助力开发者和企业聚焦产品创新，无须担心产品大规模推广所带来的高昂算力成本。

1. 提供开箱即用的大模型 API，按量收费，助力应用开发轻松实现。
   * 已上架包括 Qwen2.5-72B、DeepSeek-V2.5、Qwen2、InternLM2.5-20B-Chat、BCE、BGE、SenseVoice-Small、DeepSeek-Coder-V2、SD3 Medium、GLM-4-9B-Chat、InstantID 在内的多种开源大语言模型、图片生成模型、代码生成模型、向量与重排序模型以及多模态大模型，覆盖语言、语音、图片、视频等多场景。
   * 其中，Qwen2.5（7B）等多个大模型 API 免费使用，让开发者与产品经理无需担心研发阶段和大规模推广所带来的算力成本，实现“Token 自由”。
   * 25 年 1 月，SiliconFlow 平台上线基于华为云昇腾云服务的 DeepSeek-V3、DeepSeek-R1 推理服务。通过双方联合创新，在硅基流动自研推理加速引擎加持下，平台上的 DeepSeek 模型可获得持平全球高端 GPU 部署模型的效果。　
2. 提供高效能大模型推理加速服务，提升 GenAI 应用的用户体验。
3. 提供模型微调与部署的托管服务，用户可直接托管经过微调的大语言模型，在支撑业务迭代的同时，无需关注底层资源、服务质量，有效降低维护成本。

1. **高速推理**
   * 自研高效算子和优化框架，推理加速引擎全球领先。
   * 极致提升吞吐能力，全面支持高吞吐场景的业务需求。
   * 显著优化计算延迟，为低延迟场景提供卓越性能保障。
2. **高扩展性**
   * 动态扩容支持弹性业务模型，无缝适配多种复杂场景。
   * 一键部署自定义模型，轻松应对规模化挑战。
   * 灵活架构设计，满足多样化任务需求，支持混合云部署。
3. **高性价比**
   * 端到端极致优化，推理和部署成本显著降低。
   * 提供灵活按需付费模式，减少资源浪费，精准控制预算。
   * 支持国产异构 GPU 部署，基于企业已有投资，节省企业投入。
4. **高稳定性**
   * 经过开发者验证，保证高可靠稳定运行。
   * 提供完善的监控和容错机制，保障服务能力。
   * 提供专业技术支持，满足企业级场景需求，确保服务高可用性。
5. **高智能**
   * 提供多种先进模型服务，包括大语言模型、音视频等多模态模型。
   * 智能扩展功能，灵活适配业务规模，满足多种服务需求。
   * 智能成本分析，为业务优化提供支持，助力成本管控与效益提升。
6. **高安全性**
   * 支持 BYOC 部署，全面保护数据隐私与业务安全。
   * 计算隔离/网络隔离/存储隔离，保障数据安全。
   * 符合行业标准与合规要求，全面满足企业级用户的安全需求。

---

## SiliconFlow

**URL:** llms-txt#siliconflow

**Contents:**
- Docs
  - 2.3 文件作用
  - 2.4 与现有标准的区别：
- 3. 在其他工具中使用
- 4. 扩展阅读

## Docs
- [创建语音转文本请求](https://docs.siliconflow.cn/api-reference/audio/create-audio-transcriptions): Creates an audio transcription.
- [创建文本转语音请求](https://docs.siliconflow.cn/api-reference/audio/create-speech): 从输入文本生成音频。根据输入的文本生成音频。接口生成的数据为音频的二进制数据，需要使用者自行处理。参考：https://docs.siliconflow.cn/capabilities/text-to-speech#5
- [删除参考音频](https://docs.siliconflow.cn/api-reference/audio/delete-voice): 删除用户预置音色
- [上传参考音频](https://docs.siliconflow.cn/api-reference/audio/upload-voice): 上传用户预置音色，支持以 base64 编码或者文件形式上传，参考https://docs.siliconflow.cn/capabilities/text-to-speech#2-2)
- [参考音频列表获取](https://docs.siliconflow.cn/api-reference/audio/voice-list): 获取用户预置音色列表
...
```

#### 2.3.1 /llms.txt：

* 大规模人工智能友好导航：该文件提供了整个文档导航的简化视图，使 Cursor 或 ChatGPT 等 LLM 可以更轻松地索引您的内容。
* 将其视为人工智能的搜索引擎优化--用户现在可以直接通过通用的 LLM 找到特定产品的信息。

#### 2.3.2 /llms-full.txt：

* 文件会将所有文档文本编译成一个标记符文件，便于人工智能工具基于该文件将信息直接载入其上下文窗口。
* 可以将文档输入到 Cursor 等人工智能编码助手中，让它们根据您产品的具体细节提供上下文感知建议。

虽然 llms.txt 与 robots.txt 和 sitemap.xml 等现有标准在功能上有所重叠，但它们的目的和作用不同：

* robots.txt：用于指示搜索引擎爬虫哪些页面可以或不可以抓取，主要关注访问权限控制。
* sitemap.xml：提供网站的结构地图，帮助搜索引擎了解网站的页面布局，主要用于索引目的。
* llms.txt：为大型语言模型提供结构化的内容概述，帮助 AI 系统更好地理解和处理网站信息，提升与 AI 交互的效果。

其他平台如果支持[llms.txt 协议](https://llmstxt.org/)，也可以直接使用。
比如在 ChatGPT 中使用：

<Frame>
  <img width="500" src="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=2a08d81ff5d8eada9ebbd96f8a456c3c" data-og-width="900" data-og-height="1376" data-path="images/usercases/genai-tools/gpt-1.jpeg" data-optimize="true" data-opv="3" srcset="https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=280&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=711f9c84f7fec6a923fd5d0a7a319d01 280w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=560&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=41873fdffd15d0fec5f4c19fb6676956 560w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=840&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=a9e054934510cea357b8adecb267904a 840w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=1100&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=cf229f73e36dd8a84bd7865804e2499e 1100w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=1650&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=ab6122fbea2d47fa2975aa8df7a1afcf 1650w, https://mintcdn.com/siliconflow-37161621/JDJmbIjXH1Wv44Zd/images/usercases/genai-tools/gpt-1.jpeg?w=2500&fit=max&auto=format&n=JDJmbIjXH1Wv44Zd&q=85&s=c9c2da5644c866c6d8ae19503d9ecffa 2500w" />
</Frame>

1. The /llms.txt file, [https://llmstxt.org/](https://llmstxt.org/)
2. @Docs, [https://docs.cursor.com/context/@-symbols/@-docs](https://docs.cursor.com/context/@-symbols/@-docs)
3. LLMs.txt：AI时代的站点地图, [https://juejin.cn/post/7447083753187328050](https://juejin.cn/post/7447083753187328050)

---
