---
name: xiaohuihui-dify-tech-article
description: 专为Dify工作流案例分享设计的公众号文章生成器,遵循小灰灰公众号写作规范,自动生成包含前言、工作流制作、总结的完整Dify案例文章,配有详细的节点配置、插件安装步骤、代码示例,并支持自动生成图片上传到腾讯云COS图床
version: 1.0.0
---

# 小灰灰 Dify 案例文章生成器

专业的 Dify 工作流案例分享创作助手,完全遵循小灰灰公众号的写作风格和 Dify 特色结构规范。

## 核心功能

- ✅ **Dify专属结构**: 前言 → 工作流制作 → 总结
- ✅ **工作流节点详解**: 开始、LLM、Agent、代码执行、插件配置等
- ✅ **插件安装指南**: 第三方插件的搜索、安装、授权步骤
- ✅ **MCP工具集成**: MCP server 部署和配置说明
- ✅ **效果展示优先**: 先展示工作流效果,再介绍制作过程
- ✅ **口语化技术文**: "话不多说"、"手把手搭建"、"好很多"等亲和表达
- ✅ **魔搭社区推荐**: 优先使用魔搭社区提供的免费模型
- ✅ **真实图片生成**: 自动生成配图并上传到腾讯云 COS 图床

## 使用方法

### 基础用法
```
用小灰灰公众号风格写一篇 Dify [工作流功能] 的案例分享文章
```

### 详细用法
```
帮我写一篇小灰灰风格的 Dify 案例文章:
- 功能: [工作流实现的功能]
- 涉及插件: [需要安装的插件]
- 核心节点: [主要使用的节点类型]
- 技术栈: [MCP、第三方API等]
```

## 图片生成工作流

### 图片生成策略

生成 Dify 案例文章时,必须包含真实的图片,而非占位符。遵循以下工作流:

#### 1. 规划图片需求

根据文章内容,规划需要的图片类型和数量:

**✅ Dify 工作流必需图片类型**:
- **工作流全局图** (1张): 完整工作流的节点连接图
- **节点配置截图** (6-10张): 每个关键节点的详细配置
- **插件安装截图** (2-3张): 插件市场搜索、安装、授权界面
- **效果演示图** (2-3张): 工作流运行效果、生成结果展示
- **代码配置图** (1-2张): 代码执行节点的代码内容
- **模型配置图** (1-2张): LLM 模型选择和参数配置

**❌ 需要实际操作的图片**:
- **实际工作流截图**: 需要在 Dify 平台实际搭建
- **插件授权界面**: 需要实际安装插件后截图
- **运行日志**: 需要实际运行工作流后截图
- **效果展示**: 需要实际测试工作流效果

**图片数量建议**:
- 工作流配置截图: 8-12 张
- 插件安装截图: 2-3 张
- 效果演示: 2-3 张
- 合格标准: 总计 >= 10 张
- 优秀标准: 总计 >= 15 张

#### 2. 上传图片到 COS

使用提供的 `scripts/upload_to_cos.py` 脚本上传图片。

**前置要求**: 在项目根目录创建 `.env` 文件,配置腾讯云 COS 信息:

```bash
# .env 文件内容
COS_SECRET_ID=your-secret-id
COS_SECRET_KEY=your-secret-key
COS_BUCKET=your-bucket-name
COS_REGION=your-region
```

**上传命令**:

```bash
# 基础上传(自动生成文件名)
python scripts/upload_to_cos.py /path/to/image.png

# 自定义文件名
python scripts/upload_to_cos.py /path/to/image.png --name workflow-20251122.png

# 静默模式(只输出 URL)
python scripts/upload_to_cos.py /path/to/image.png --quiet
```

#### 3. 使用真实 URL

上传成功后,在文章中使用返回的完整 COS URL:

```markdown
![工作流全局图](https://your-bucket.cos.your-region.myqcloud.com/image-20251122-143025.png)
```

### 图片命名规范

- **自动生成**: `image-YYYYMMDD-HHMMSS.extension`
- **语义化**: `workflow-20251122.png`, `plugin-install-20251122.png`, `node-config-20251122.png`

### 图片质量要求

- 尺寸: 1200x800 或 16:9 比例(横向)
- 格式: PNG(截图/UI)
- 大小: < 500KB/张
- 清晰度: 文字清晰可读

## 文章结构模板

### 第1章: 前言 (约300-400字)

#### 第一段: 技术背景介绍 (100-150字)

介绍相关技术概念或应用场景,说明其重要性。

**示例:**
```
RSS(Really Simple Syndication)是一种基于XML的网络内容分发格式,
主要用于将新闻、博客、论坛等频繁更新的内容以订阅的方式提供给用户。
它允许用户通过RSS阅读器在一个界面中跟踪多个网站的更新,
而无需手动访问每个网站。
```

#### 第二段: 问题或需求引入 (100-150字)

描述用户痛点或需求,引出本文要解决的问题。

**示例:**
```
之前给大家做过一期文生视频的dify工作流的案例,
使用的是智普提供文生视频功能。
之前的这个文生视频效果一般般,用户体验不是太好。
有没有办法实现调用即梦AI实现文生视频功能,而且还免费呢?
```

#### 第三段: 解决方案和效果展示 (100-150字)

引入本文的 Dify 工作流方案,展示效果图。

**固定句式:**
```
今天给大家带来一个基于dify工作流的[功能名称]。
下面大家看看一下工作流以及工作流生成[功能]的效果。

![工作流全局图](图片URL)

生成的效果如下:

![效果展示](图片URL)

那么这样的基于dify工作流的[功能]是如何制作的呢?话不多说,下面开始干活。
```

---

### 第2章: 工作流制作 (约1500-2500字)

#### 2.1 前置准备(如需要)

**插件安装模板:**
````markdown
## [插件名称]安装

我们在dify的插件市场中查找名称"[插件名称]"

![插件搜索](图片URL)

搜索到这个插件后,点击"安装"按钮完成插件的安装。

![插件安装](图片URL)

安装完成后,我们可以在已经安装的插件列表中查询到

![插件列表](图片URL)

## [插件名称]授权

插件安装完成后,我们打开[插件名称]点击"授权"按钮

![插件授权](图片URL)

这里[填写授权参数说明],我们点击保存就可以了

![授权完成](图片URL)
````

**MCP Server 部署模板:**
````markdown
## MCP Server 部署

这个工作流核心是一个基于[mcp-server名称]的开源项目。
项目地址: https://github.com/xxx/xxx

![项目地址](图片URL)

我们要使用这个mcp-server功能,所以我们需要把这个项目部署起来。
目前这个项目比较完整支持docker和源码部署。

部署命令:
```bash
# Docker 部署
docker run -d \
  --name mcp-server \
  -p 8005:8005 \
  image:latest
```

部署完成后,访问地址: http://your-server:8005/mcp
````

#### 2.2 工作流搭建

**开始节点模板:**
````markdown
## 开始

我们首先在工作流平台上创建一个 chatflow/workflow。

![创建工作流](图片URL)

创建完成后,我们就可以设置一下开始节点。
这个开始节点需要设置一个[参数名称],用于[参数用途]。

![开始节点配置](图片URL)

我们这里提供[选项列表]供用户选择。

![参数选项](图片URL)

上面我们就完成了开始节点的配置。
````

**LLM节点模板:**
````markdown
## LLM大语言模型

大语言模型这块我们选择魔搭社区提供的免费[模型名称]模型。
关于这个模型大家可以在魔搭社区广场找到。

![模型选择](图片URL)

目前魔搭社区提供每天2000次的模型调用,个人测试使用基本上是够用了。

![免费额度](图片URL)

系统提示词内容如下:

```
你是一个[角色定义],用户输入[输入描述],
通过[处理方式]生成[输出描述]。

举例:
输入:[示例输入]
输出:[示例输出]
```

模型其他参数:
- 模型: [模型名称]
- 温度: 0.7
- 最大token: 2000

![LLM配置](图片URL)
````

**Agent节点模板:**
````markdown
## Agent策略

这个工作流用到Agent策略,如果dify平台上没有安装Agent策略插件的可以先安装一下。

我们可以在插件市场-Agent策略找到这个插件。

![Agent插件](图片URL)

插件安装完成后,我们可以在已安装插件上查找到

![插件列表](图片URL)

Agent配置:
- 推理模型: [模型名称]
- MCP工具: [工具名称]
- 最大迭代: 5

![Agent配置](图片URL)
````

**代码执行节点模板:**
````markdown
## 代码执行

这个代码执行节点主要是通过代码的方式处理[处理内容]。

输入参数:
- arg1: [参数描述]
- arg2: [参数描述]

![输入参数](图片URL)

输出变量:
- result: [返回描述],返回类型是 string/object

中间处理的代码如下:

```python
import json

def main(arg1: str, arg2: str) -> dict:
    # 处理逻辑
    result = process_data(arg1, arg2)
    return {
        "result": result
    }
```

![代码内容](图片URL)
````

**HTTP请求节点模板:**
````markdown
## HTTP请求

这里我们需要一个HTTP请求,调用[API名称]接口。

请求配置:
- 方法: POST
- URL: https://api.example.com/v1/generate
- Headers:
  ```json
  {
    "Authorization": "Bearer {{auth_token}}",
    "Content-Type": "application/json"
  }
  ```
- Body:
  ```json
  {
    "prompt": "{{prompt}}",
    "model": "gpt-4"
  }
  ```

![HTTP配置](图片URL)

返回数据格式:
```json
{
  "status": "success",
  "data": {
    "result": "生成的内容"
  }
}
```
````

#### 2.3 测试验证

**模板:**
````markdown
## 测试验证

配置完成后,我们点击"运行"按钮测试工作流。

![运行测试](图片URL)

输入测试内容:
[测试输入示例]

查看运行日志:

![运行日志](图片URL)

查看生成结果:

![生成结果](图片URL)

通过对比来看效果不错,基本达到预期。话不多说,是不是很简单?
````

---

### 第3章: 总结 (单段300-400字,禁止分段)

**标准模板** (必须严格遵守):

```
今天主要带大家了解并实现了基于Dify工作流的[功能全称]完整流程,
该工作流以"[核心技术1 + 核心技术2]"为核心,
结合[应用场景]需求,
通过[节点1]、[节点2]、[节点3]等关键节点,
配合[插件名称]插件和[工具名称]工具,
形成了一套从[起点]到[终点]的完整解决方案。
通过这套Dify工作流,[用户群体]能够高效实现[核心价值] ——
借助[具体操作](包括[步骤1]、[步骤2]、[步骤3]),
无需[传统障碍],
就能快速[核心功能](如本次演示的"[案例名称]")。
无论是[功能1]、[功能2],还是[功能3]、[功能4],
都能通过简单的节点配置完成,
极大[提升维度]。
在实际应用中,该工作流不仅[优势1],还[优势2],
适配性远优于[传统方案];
特别是通过[关键技术点],有效解决了[具体问题]的难题。
同时,工作流具备良好的扩展性 ——
小伙伴们可以基于此扩展更多[应用场景],
如[场景1]、[场景2]、[场景3]等,
进一步发挥Dify工作流在[领域1]、[领域2]等领域的应用价值。
感兴趣的小伙伴可以按照文中提供的步骤进行实践,
根据实际[需求类型]调整[可调整项]。
今天的分享就到这里结束了,我们下一篇文章见。
```

**检查清单:**
- [ ] 单段不分段
- [ ] 300-400字
- [ ] 强调 Dify 工作流
- [ ] 列举4+功能/节点
- [ ] 对比传统方案
- [ ] 3+扩展场景
- [ ] 固定结束语

---

### 第4章: 附加资源(可选)

```markdown
## 项目资源

**工作流DSL**:
提供工作流的DSL文件供下载导入。

**相关链接**:
- Dify官网: https://dify.ai
- 插件市场: https://marketplace.dify.ai
- 魔搭社区: https://modelscope.cn

**在线体验**:
如果提供了在线体验地址,可以添加。

**附件代码**:
网盘分享: dify-workflow.zip
链接: https://pan.baidu.com/s/xxx 提取码: abcd

#首发于魔搭研习社
```

---

## Dify 特色语言风格

### Dify 专用词汇

**工作流相关:**
- "工作流节点"、"chatflow"、"workflow"
- "开始节点"、"LLM节点"、"Agent节点"、"代码执行节点"
- "条件分支"、"变量聚合器"、"直接回复"
- "上下文变量"、"系统变量"

**插件相关:**
- "插件市场"、"第三方插件"、"插件授权"
- "已安装插件"、"插件升级"

**模型相关:**
- "魔搭社区"、"免费额度"、"每天2000次调用"
- "大语言模型"、"系统提示词"

**MCP相关:**
- "MCP server"、"MCP工具"、"streamable-http"
- "MCP协议"、"双向MCP"

### 口语化表达

**必用词汇:**
- 问候语: "小伙伴们"、"大家"、"给大家"
- 语气词: "话不多说"、"下面开始干活"、"好很多"
- 疑问引导: "是不是很简单?"、"效果不错吧?"
- 对话感: "我们接下来..."、"手把手搭建"

**时效性标签:**
- "今天给大家带来"
- "最新推出"
- "下面介绍一下..."

---

## Dify 特色视觉元素

### 图片格式

**必须使用真实的腾讯云 COS URL**:

```markdown
![图片描述](https://your-bucket.cos.your-region.myqcloud.com/image-20251122-143025.png)
```

**Dify 特色图片类型:**
- 工作流全局图
- 节点配置截图
- 插件市场截图
- 授权界面截图
- 代码执行截图
- 运行日志截图
- 效果展示图

### 代码块规范

**Python代码:**
````markdown
```python
import json

def main(arg1: str) -> dict:
    # 处理逻辑
    data = json.loads(arg1)
    result = process(data)
    return {"result": result}
```
````

**系统提示词:**
````markdown
```
你是一个[角色],用户输入[内容],
生成[结果]。

举例:
输入:[示例]
输出:[示例]
```
````

**HTTP请求:**
````markdown
```json
{
  "method": "POST",
  "url": "https://api.example.com",
  "body": {
    "prompt": "{{prompt}}"
  }
}
```
````

**工作流DSL:**
````markdown
```yaml
version: "1.0"
nodes:
  - id: start
    type: start
    config:
      variables:
        - name: query
          type: string
```
````

---

## 质量标准

### 合格标准 (必达)
- ✅ 总字数 > 1800字
- ✅ 标题格式: "dify案例分享-[功能名称]"
- ✅ 工作流截图 >= 10个
- ✅ 节点配置说明 >= 5个
- ✅ 代码块 >= 3个
- ✅ 总结单段 300-400字
- ✅ 固定结束语
- ✅ 强调魔搭社区免费模型

### 优秀标准 (建议)
- 🌟 总字数 > 2500字
- 🌟 工作流截图 >= 15个
- 🌟 节点配置说明 >= 8个
- 🌟 代码块 >= 5个
- 🌟 包含插件安装步骤
- 🌟 包含MCP集成说明
- 🌟 提供在线体验或DSL下载

---

## 错误避免

### ❌ 禁止
1. 总结分段
2. 缺少工作流全局图
3. 节点配置说明不清
4. 省略插件安装步骤
5. 缺少效果展示
6. 不提魔搭社区
7. 使用占位符图片

### ✅ 正确
1. 口语化专业
2. 工作流步骤完整
3. 节点配置详细
4. 截图充分清晰
5. 代码可直接使用
6. 优先推荐魔搭免费模型
7. 总结深入单段

---

## Dify 案例分类

### 常见工作流类型

**文本处理类:**
- 文本生成、文本转换、文本摘要
- 翻译、语法检查、内容优化

**图像处理类:**
- 文生图、图生图、图像识别
- OCR识别、图像转视频

**视频处理类:**
- 文生视频、图生视频
- 视频摘要、字幕生成

**数据处理类:**
- 数据抓取、数据清洗
- 数据可视化、图表生成

**集成应用类:**
- 飞书集成、企业微信集成
- 数据库查询、API调用

**MCP工具类:**
- MCP server集成
- 双向MCP协议应用

---

## 触发方式

自动触发关键词:
- "Dify" + "工作流"
- "Dify" + "案例"
- "魔搭" + "Dify"
- "插件" + "Dify"

---

## 更新日志

### v1.0.0 (2025-11-22)
- ✅ 初始版本
- ✅ Dify 专属结构
- ✅ 工作流节点详解
- ✅ 插件安装指南
- ✅ MCP工具集成
- ✅ 口语化风格
- ✅ 质量标准

---

## 技术支持

参考文档:
- xiaohuihui-dify-tech-article2/ - Dify案例示例文章集合
- xiaohuihui-tech-article/ - 通用技术文章模板参考
