---
name: arxiv-reader
description: arXiv 論文の内容を取得・要約するスキル。URL が arxiv.org/abs/{論文ID} 形式の場合に使用。PDF をダウンロードして Read ツールで読み取る。
---

# arXiv 論文読み取り

## 手順

### 1. WebFetch でメタデータを取得

- WebFetch で arXiv ページを取得
- 以下を抽出：
  - 論文タイトル
  - 著者一覧
  - アブストラクト
  - カテゴリ（cs.SE、cs.AI など）
  - 公開日

### 2. PDF をダウンロードして読み取り

より詳細な内容が必要な場合、PDF をダウンロード：

```bash
curl -L -o /tmp/paper.pdf "https://arxiv.org/pdf/{論文ID}.pdf"
```

ダウンロード後、Read ツールで PDF を直接読み取り：
- Read ツールは PDF を直接読み取れる（マルチモーダル機能）
- 図表や数式も視覚的に解析可能

### 3. 要約に含める内容

- 研究の目的・背景
- 提案手法の概要
- 主要な貢献（Contributions）
- 実験結果・評価
- 結論
- 関連技術・キーワード

### 4. 読了時間の推定

- ページ数 × 3〜5分 を目安に（技術論文のため）

### 5. 補足情報

- 関連する先行研究があれば言及
- 専門用語の簡単な説明
