---
name: hwp-converter
description: Convert Hancom Word Processor documents (.hwp/.hwpx) to text, HTML, or Markdown. Preserves structure including tables. Use for content extraction or format conversion.
---

# HWP / HWPX Converter

Extracts full readable text and tables from Korean Hangul Word Processor documents.

## Dependencies

This skill requires the following Python packages:
```bash
pip install olefile Pillow --break-system-packages
```

## Instructions

Run the HWP5 converter for `.hwp` files (HWP 5.x binary format):
```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwp5.converter <file_path> [output_path] [--format txt|html|md]
```

Run the HWPX converter for `.hwpx` files (HWPX XML format):
```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwpx.converter <file_path> [output_path] [--format txt|html|md]
```

## Examples

### Converting `.hwp` file

```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwp5.converter /mnt/user-data/uploads/document.hwp /mnt/user-data/outputs/document.txt
```

### Converting `.hwp` file to HTML
```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwp5.converter /mnt/user-data/uploads/document.hwp /mnt/user-data/outputs/document.html --format html
```

### Converting `.hwpx` file
```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwpx.converter /mnt/user-data/uploads/document.hwpx /mnt/user-data/outputs/document.txt
```

### Converting `.hwpx` file to Markdown
```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwpx.converter /mnt/user-data/uploads/document.hwpx /mnt/user-data/outputs/document.md --format md
```

### Extracting Images from `.hwp` file

```bash
cd /mnt/skills/user/hwp-converter
python -m scripts.hwp5.extract_images /mnt/user-data/uploads/document.hwp /mnt/user-data/outputs/images
```

### Reading the output


After successful execution, read the output file:
```bash
cat /mnt/user-data/outputs/document.txt
```
