
import sys
import os
import unittest

# Add project root to path
sys.path.append("/Users/yong/claude-hwp-converter-skill/hwp-converter")

from scripts.hwp5.parser import Table, TableCell
from scripts.hwpx.converter import HwpxTable

class TestConversion(unittest.TestCase):
    def test_hwp5_table_html(self):
        # Create a 2x2 table
        cells = [
            TableCell(col=0, row=0, col_span=1, row_span=1, text="A"),
            TableCell(col=1, row=0, col_span=1, row_span=1, text="B"),
            TableCell(col=0, row=1, col_span=1, row_span=1, text="C"),
            TableCell(col=1, row=1, col_span=1, row_span=1, text="D"),
        ]
        table = Table(row_count=2, col_count=2, cells=cells)
        html = table.to_html()
        self.assertIn("<td>A</td>", html)
        self.assertIn("<td>D</td>", html)
        self.assertIn("<table", html)

    def test_hwp5_table_markdown(self):
        cells = [
            TableCell(col=0, row=0, col_span=1, row_span=1, text="Header1"),
            TableCell(col=1, row=0, col_span=1, row_span=1, text="Header2"),
            TableCell(col=0, row=1, col_span=1, row_span=1, text="Val1"),
            TableCell(col=1, row=1, col_span=1, row_span=1, text="Val2"),
        ]
        table = Table(row_count=2, col_count=2, cells=cells)
        md = table.to_markdown()
        self.assertIn("| Header1 | Header2 |", md)
        self.assertIn("| --- | --- |", md)
        self.assertIn("| Val1 | Val2 |", md)

    def test_hwpx_table_html(self):
        rows = [["A", "B"], ["C", "D"]]
        table = HwpxTable(rows=rows)
        html = table.to_html()
        self.assertIn("<td>A</td>", html)
        self.assertIn("<td>D</td>", html)

    def test_hwpx_table_markdown(self):
        rows = [["H1", "H2"], ["V1", "V2"]]
        table = HwpxTable(rows=rows)
        md = table.to_markdown()
        self.assertIn("| H1 | H2 |", md)
        self.assertIn("| --- | --- |", md)

if __name__ == '__main__':
    unittest.main()
