# 微博热搜产品创意分析 - 斜杠命令使用指南

## 🚀 快速开始

### 基础用法
```bash
/weibo-hotsearch-idea-analyzer
```

### 自定义参数
```bash
/weibo-hotsearch-idea-analyzer --topics 15 --focus tech,lifestyle
```

## 📋 完整参数说明

| 参数 | 短参数 | 类型 | 默认值 | 说明 | 示例 |
|------|--------|------|--------|------|------|
| `--topics` | `-t` | integer | 10 | 分析话题数量 (5-20) | `--topics 15` |
| `--output` | `-o` | string | ./output/reports | 报告输出目录 | `--output ./my-reports` |
| `--focus` | `-f` | string | all | 专注行业领域 | `--focus tech,lifestyle` |
| `--weights` | `-w` | string | 80,20 | 评分权重比 | `--weights 70,30` |
| `--ideas` | `-i` | integer | 3 | 每话题创意数 (1-5) | `--ideas 5` |
| `--quiet` | `-q` | flag | false | 静默模式 | `--quiet` |
| `--help` | `-h` | flag | false | 显示帮助 | `--help` |

## 🎯 使用场景示例

### 1. 快速分析 (默认配置)
```bash
/weibo-hotsearch-idea-analyzer
```
- 分析10个话题
- 每话题生成3个创意
- 使用80/20评分权重
- 输出到默认目录

### 2. 深度分析
```bash
/weibo-hotsearch-idea-analyzer --topics 20 --ideas 5 --weights 70,30
```
- 分析20个话题 (最大数量)
- 每话题生成5个创意 (最多数量)
- 调整权重为70/30 (更重视有用度)

### 3. 专注特定领域
```bash
/weibo-hotsearch-idea-analyzer --focus tech --topics 12
```
- 专注科技领域
- 分析12个话题
- 其他参数使用默认值

### 4. 多领域分析
```bash
/weibo-hotsearch-idea-analyzer --focus tech,lifestyle,finance --weights 85,15
```
- 同时关注科技、生活、金融三个领域
- 更重视有趣度 (85/15权重)

### 5. 自定义输出
```bash
/weibo-hotsearch-idea-analyzer --output ./project-reports --quiet
```
- 输出到指定目录
- 静默模式 (减少输出)

### 6. 完整自定义
```bash
/weibo-hotsearch-idea-analyzer --topics 8 --focus tech --weights 75,25 --ideas 4 --output ./tech-reports
```
- 分析8个科技话题
- 75/25评分权重
- 每话题4个创意
- 输出到科技报告目录

## 🏆 评分系统说明

### 有趣度评分 (默认80%权重)
- **新颖性因素** (25%): 产品概念的创新性和独特性
- **参与潜力** (25%): 用户互动和社交传播可能性
- **趋势契合度** (15%): 与当前热点趋势的匹配度
- **故事潜力** (15%): 产品背后的故事性和传播价值

### 有用度评分 (默认20%权重)
- **问题解决能力** (10%): 解决实际问题的有效性
- **市场可行性** (5%): 商业模式和盈利潜力
- **用户价值** (5%): 为目标用户创造的价值

### 评分等级
- **🌟 优秀 (80-100分)**: 强烈推荐开发，市场前景广阔
- **⭐ 良好 (60-79分)**: 值得考虑，建议进一步调研
- **💡 一般 (40-59分)**: 有待改进，需要优化核心价值
- **📝 有限 (0-39分)**: 需要重新评估或寻找新方向

## 🎨 行业领域说明

支持以下专注领域：

- **tech**: 科技、互联网、人工智能、区块链
- **lifestyle**: 生活方式、消费、娱乐、时尚
- **finance**: 金融、投资、理财、保险
- **entertainment**: 娱乐、影视、游戏、音乐
- **education**: 教育、培训、学习、知识付费
- **all**: 全部领域 (默认)

## 📊 输出文件

分析完成后会生成以下文件：

### 1. HTML报告
- **文件名**: `weibo_analysis_YYYYMMDD_HHMMSS.html`
- **内容**: 完整的产品创意分析报告
- **特点**:
  - 响应式设计，支持各种设备
  - 美观的可视化图表
  - 详细的产品创意信息
  - 评分和推荐意见

### 2. JSON数据文件
- **文件名**: `latest_analysis_result.json`
- **内容**: 结构化的分析数据
- **用途**: 便于程序处理和二次开发

## 🔧 配置选项

### 权重调整建议

- **创业公司**: 推荐使用 `--weights 70,30` (更重视有用度)
- **内容创业**: 推荐使用 `--weights 85,15` (更重视有趣度)
- **企业产品**: 推荐使用 `--weights 60,40` (平衡有趣和有用)
- **学术研究**: 推荐使用 `--weights 50,50` (完全平衡)

### 话题数量建议

- **快速分析**: `--topics 5` (5分钟内完成)
- **标准分析**: `--topics 10` (10-15分钟)
- **深度分析**: `--topics 15` (20-30分钟)
- **全面分析**: `--topics 20` (30-45分钟)

### 创意数量建议

- **快速浏览**: `--ideas 1` (每话题1个最佳创意)
- **标准分析**: `--ideas 3` (每话题3个创意)
- **深度挖掘**: `--ideas 5` (每话题5个创意)

## ⚠️ 注意事项

### API限制
- 天行数据API有调用频率限制
- 建议不要频繁执行大量分析
- 如需高频使用，请考虑缓存机制

### 网络要求
- 需要稳定的网络连接
- 某些网络环境可能需要代理

### 资源需求
- 分析过程会消耗一定的CPU和内存资源
- 建议在性能较好的环境中运行

## 🐛 故障排除

### 常见错误及解决方案

#### 1. 参数错误
```
错误: 权重之和必须为100
解决: 确保两个权重参数相加等于100
```

#### 2. 输出目录错误
```
错误: 无法创建输出目录
解决: 检查目录权限，使用绝对路径
```

#### 3. API连接失败
```
错误: 天行数据API连接失败
解决: 检查网络连接和API密钥配置
```

#### 4. 模块导入错误
```
错误: 无法导入分析模块
解决: 确认文件结构完整，检查Python环境
```

### 调试技巧

1. **使用静默模式**: `--quiet` 减少输出，便于查看错误信息
2. **减少话题数量**: 从 `--topics 5` 开始测试
3. **检查配置**: 使用默认配置逐步添加自定义参数

## 💡 最佳实践

### 工作流建议

1. **初期探索**: 使用默认参数快速了解热点
2. **重点分析**: 使用 `--focus` 专注相关领域
3. **深度研究**: 增加话题数和创意数量
4. **结果优化**: 根据分析结果调整权重和参数

### 定期分析

建议建立定期分析的习惯：
- **每日**: 快速查看当日热点
- **每周**: 深度分析热门趋势
- **每月**: 全面评估市场机会

### 结果利用

1. **创意筛选**: 重点关注80分以上的创意
2. **市场调研**: 对高分创意进行深入调研
3. **团队讨论**: 将分析结果分享给团队
4. **产品规划**: 基于分析结果制定产品路线图

## 📞 获取帮助

如果遇到问题，可以：

1. **查看帮助**: 使用 `/weibo-hotsearch-idea-analyzer --help`
2. **查看文档**: 参考本使用指南
3. **检查日志**: 查看详细的错误信息
4. **联系支持**: 提交问题到项目仓库

---

## 🎉 开始使用

现在您已经了解了如何使用微博热搜产品创意分析斜杠命令！

**推荐首次使用**:
```bash
/weibo-hotsearch-idea-analyzer --topics 5 --quiet
```

祝您分析顺利，发现更多产品创意机会！ 🚀