#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
熔断器功能测试脚本
"""

import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from src.core.tianapi_scraper import (
    api_client,
    get_circuit_breaker_status,
    reset_circuit_breaker,
    test_api_connection
)


def test_circuit_breaker_normal_operation():
    """测试熔断器正常运行"""
    print("=== 测试熔断器正常运行 ===")

    # 重置熔断器状态
    reset_circuit_breaker()

    # 显示初始状态
    print("初始熔断器状态:", get_circuit_breaker_status())

    # 测试API连接
    success = test_api_connection()
    print(f"API连接测试结果: {'成功' if success else '失败'}")

    # 显示测试后状态
    print("测试后熔断器状态:", get_circuit_breaker_status())
    print()


def test_circuit_breaker_status_monitoring():
    """测试熔断器状态监控"""
    print("=== 测试熔断器状态监控 ===")

    status = get_circuit_breaker_status()
    print("当前熔断器状态:")
    for key, value in status.items():
        print(f"  {key}: {value}")
    print()


def test_circuit_breaker_with_invalid_api():
    """测试熔断器在无效API下的行为"""
    print("=== 测试熔断器在无效API下的行为 ===")

    # 保存原始API key
    original_key = api_client.api_key

    try:
        # 设置无效API key来触发失败
        api_client.api_key = "invalid_api_key_for_testing"

        print("使用无效API key进行多次请求测试...")

        # 发起多次请求以触发熔断器
        for i in range(7):  # 超过失败阈值5次
            print(f"\n第 {i+1} 次请求:")
            result = api_client.fetch_weibo_hotsearch(1)
            print(f"请求结果: {'成功' if result else '失败'}")
            print("当前状态:", get_circuit_breaker_status())

            if result is None:
                state = get_circuit_breaker_status()
                if state['state'] == 'OPEN':
                    print("熔断器已打开，停止测试")
                    break

    finally:
        # 恢复原始API key
        api_client.api_key = original_key
        print("\n已恢复原始API key")

    print()


def main():
    """主测试函数"""
    print("熔断器功能测试开始\n")

    # 1. 测试正常运行
    test_circuit_breaker_normal_operation()

    # 2. 测试状态监控
    test_circuit_breaker_status_monitoring()

    # 3. 测试熔断器行为
    print("=== 测试熔断器在无效API下的行为 ===")
    test_circuit_breaker_with_invalid_api()

    print("熔断器功能测试完成")


if __name__ == "__main__":
    main()