# 微博热搜产品创意分析Skill

基于Claude Code框架的智能微博热搜分析工具，能够自动抓取微博热搜数据，分析热点话题背景，生成创新产品创意并提供专业的评分系统。

## 🎯 核心功能

### 🔍 数据收集与分析
- **实时热搜抓取**: 通过天行数据API获取最新微博热搜榜单
- **深度背景研究**: 使用Web Search工具为每个热搜话题收集新闻和背景信息
- **智能数据整理**: 自动分析话题情感、市场活跃度和关键事件

### 💡 AI创意生成
- **创新产品创意**: 基于热点话题生成具体的产品概念
- **目标用户分析**: 详细定义产品面向的用户群体和使用场景
- **核心功能设计**: 为每个创意设计具体的功能和特性

### 📊 专业评分系统
- **有趣度评分 (80%权重)**: 新颖性、参与潜力、趋势契合度、故事潜力
- **有用度评分 (20%权重)**: 问题解决能力、市场可行性、用户价值
- **智能分类**: 自动将创意分为优秀(80+)、良好(60-79)、一般(40-59)三个等级

### 📋 可视化报告
- **专业HTML报告**: 美观易读的分析报告
- **评分可视化**: 优秀创意金色高亮，良好创意蓝色强调
- **响应式设计**: 支持桌面端和移动端浏览

## 🏗️ 技术架构

```
weibo-hotsearch-idea-analyzer/
├── SKILL.md                          # 核心技能配置文件
├── README.md                         # 项目说明文档
├── src/
│   ├── core/
│   │   ├── tianapi_scraper.py        # 天行数据微博热搜API集成
│   │   ├── news_analyzer.py          # 新闻信息搜索和分析模块
│   │   ├── idea_generator.py         # 产品创意生成模块
│   │   └── scorer.py                 # 评分算法模块
│   ├── config/
│   │   └── api_config.py             # API配置和密钥管理
│   ├── templates/
│   │   └── report_template.html      # HTML报告模板
│   └── utils/
│       └── html_generator.py         # HTML报告生成器
├── output/
│   └── reports/                      # 生成的报告输出目录
```

## 🚀 使用方法

### 基础用法
```
"分析微博热搜并生成产品创意报告"
```

### 高级用法
```
"获取微博热搜榜单，分析前10个话题的背景信息，并生成详细的产品创意分析报告，重点关注科技和生活类产品"
```

## 📋 API配置

### 天行数据API
- **API地址**: https://apis.tianapi.com/weibohot/index
- **密钥**: 9e9b942a7a12bb1b1f4aa5c83ace6f26
- **功能**: 获取实时微博热搜榜单数据

### 配置文件位置
- `src/config/api_config.py`: API密钥和配置参数

## 📊 评分体系详解

### 有趣度评分 (80%权重)
- **新颖性因素 (25%)**: 评估产品概念的创新性和独特性
- **参与潜力 (25%)**: 分析用户互动和社交传播可能性
- **趋势契合度 (15%)**: 评估与当前热点趋势的匹配度
- **故事潜力 (15%)**: 分析产品背后的故事性和传播价值

### 有用度评分 (20%权重)
- **问题解决能力 (10%)**: 评估解决实际问题的有效性
- **市场可行性 (5%)**: 分析商业模式和盈利潜力
- **用户价值 (5%)**: 评估为目标用户创造的价值

### 评分等级
- **🌟 优秀 (80-100分)**: 金色高亮 - 强烈推荐开发，市场前景广阔
- **⭐ 良好 (60-79分)**: 蓝色强调 - 值得考虑，建议进一步调研
- **💡 一般 (40-59分)**: 灰色显示 - 有待改进，需要优化核心价值

## 🔧 安装与部署

### 环境要求
- Python 3.7+
- requests库 (用于API调用)
- jinja2库 (用于HTML模板渲染)

### 安装依赖
```bash
pip install requests jinja2
```

### 目录结构
将整个skill目录放置在Claude Code的技能目录中：
```
your-claude-project/
└── skills/
    └── weibo-hotsearch-idea-analyzer/
        ├── SKILL.md
        ├── src/
        └── ...
```

## 📝 输出报告示例

生成的HTML报告包含以下内容：

### 1. 统计概览
- 分析话题总数
- 生成创意总数
- 各等级创意数量
- 平均评分

### 2. 热点事件脉络
- 热搜话题时间线
- 话题热度排序
- 关键事件展示

### 3. 产品创意详情
- **产品名称**: 创意且易记的产品名称
- **核心功能**: 具体的功能特性描述
- **目标用户**: 详细的用户画像和使用场景
- **评分详情**: 完整的评分分析和推荐意见

### 4. 评分方法说明
- 详细的评分标准解释
- 各维度权重说明
- 等级分类标准

## 🎨 报告特色

### 视觉设计
- **现代化UI**: 采用渐变色和卡片式设计
- **响应式布局**: 完美适配各种设备屏幕
- **动画效果**: 流畅的页面加载和交互动画
- **色彩编码**: 不同等级创意用不同颜色突出显示

### 用户体验
- **清晰结构**: 逻辑清晰的信息层次
- **重点突出**: 高分创意显著标注
- **详细分析**: 每个创意都有完整的评估说明
- **专业美观**: 适合商业展示和报告分享

## 🔍 使用场景

### 创业团队
- 快速发现市场机会
- 验证产品创意方向
- 准备创业项目提案

### 产品经理
- 分析市场趋势
- 获取产品灵感
- 评估竞争环境

### 投资机构
- 发现投资机会
- 评估项目潜力
- 市场研究支持

### 市场研究人员
- 社交媒体趋势分析
- 用户需求洞察
- 产品机会挖掘

## ⚙️ 配置选项

### 分析参数
- `max_topics_to_analyze`: 最大分析话题数量 (默认: 10)
- `search_queries_per_topic`: 每个话题的搜索查询数量 (默认: 3)
- `num_ideas_per_topic`: 每个话题生成的创意数量 (默认: 3)

### 评分权重
- `interestingness_weight`: 有趣度权重 (默认: 0.8)
- `usefulness_weight`: 有用度权重 (默认: 0.2)

## 🚨 注意事项

### API限制
- 天行数据API有调用频率限制
- 建议合理安排分析频率
- 注意API密钥的安全性

### 数据准确性
- 热搜数据具有时效性
- 分析结果基于公开信息
- 建议结合其他数据源进行验证

### 创意评估
- 评分算法基于预设标准
- 实际市场表现可能有所差异
- 建议结合用户调研验证

## 🤝 贡献指南

欢迎提交Issue和Pull Request来改进这个skill：

1. Fork项目
2. 创建特性分支
3. 提交更改
4. 发起Pull Request

## 📄 许可证

本项目采用MIT许可证 - 详见LICENSE文件

## 📞 联系方式

如有问题或建议，请通过以下方式联系：
- 提交GitHub Issue
- 发送邮件反馈

---

**注意**: 本工具仅供学习和参考使用，实际的产品开发需要进行更深入的市场调研和技术可行性分析。