---
name: weibo-hotsearch-idea-analyzer
description: "Analyzes Weibo hot search trends to generate innovative product ideas with scoring system. When user needs to extract product creativity from trending topics, conduct market trend analysis, or generate startup ideas based on social media hotspots. Uses web search to gather background information and AI analysis to evaluate ideas from interestingness (80%) and usefulness (20%) perspectives. Generates comprehensive HTML reports with timeline visualization and highlighted high-scoring ideas."
license: MIT
---

# Weibo Hot Search Product Idea Analyzer

## Overview

This skill transforms Weibo hot search trends into actionable product ideas through systematic analysis and AI-powered creativity evaluation. It combines real-time trend data with comprehensive background research to generate innovative product concepts with detailed scoring.

## Core Capabilities

### Trend Analysis & Data Collection
- **Hot Search Scraping**: Automatically fetches latest Weibo trending topics using TianAPI integration
- **Background Research**: Performs comprehensive web searches for each trending topic to gather news, context, and market information
- **Data Structuring**: Organizes trend data with timeline, topic categorization, and sentiment analysis

### AI-Powered Idea Generation
- **Creative Analysis**: Generates product ideas focusing on **interestingness (80%)** and **usefulness (20%)** scoring framework
- **Innovation Scoring**: Evaluates each idea based on market potential, uniqueness, feasibility, and user value
- **Target Audience Identification**: Defines specific user segments and use cases for each product concept

### Report Generation & Visualization
- **HTML Reports**: Creates clean, static HTML reports with professional styling and responsive design
- **Trend Mapping**: Visualizes hot topic evolution and relationship networks
- **Scoring Visualization**: Highlights excellent ideas (80+ points) in gold and good ideas (60-79 points) in blue
- **Comprehensive Analytics**: Combines quantitative scoring with qualitative analysis

## Workflow Process

### Phase 1: Data Collection & Analysis
1. **Hot Search Retrieval**: Fetch current Weibo trending topics via TianAPI
2. **Topic Research**: For each trending topic, perform targeted web searches to gather:
   - News articles and press coverage
   - Social media discussions and sentiment
   - Market context and related events
   - Historical trend data if available
3. **Data Processing**: Structure collected information for AI analysis

### Phase 2: Creative Idea Generation
1. **AI Analysis**: Analyze trending topics for product opportunity gaps
2. **Idea Generation**: Create product concepts following this structure:
   - **Product Name**: Catchy, memorable name reflecting core value
   - **Core Functionality**: Primary features and user benefits
   - **Target Audience**: Detailed user persona and use case scenarios
3. **Scoring Evaluation**: Apply dual-criteria scoring:
   - **Interestingness Score (80% weight)**: Novelty, engagement potential, virality factors
   - **Usefulness Score (20% weight)**: Practical value, market need, problem-solving capability

### Phase 3: Report Generation
1. **HTML Compilation**: Generate comprehensive report including:
   - Executive summary with key statistics
   - Hot topic timeline and evolution visualization
   - Detailed product idea cards with scores
   - Market opportunity analysis
2. **Visual Enhancement**: Apply professional styling with:
   - Color-coded scoring badges (gold for excellent, blue for good)
   - Interactive idea cards with hover effects
   - Responsive layout for various devices
3. **Quality Validation**: Ensure all links work and content is properly formatted

## Usage Instructions

### Basic Usage
```
"分析微博热搜并生成产品创意报告"
```
```
"Generate product ideas from Weibo hot search trends"
```

### Advanced Usage
```
"获取微博热搜榜单，分析前10个话题的背景信息，并生成详细的产品创意分析报告，重点关注科技和生活类产品"
```
```
"Analyze the top 10 Weibo trending topics, research their background, and create a detailed product opportunity report focusing on tech and lifestyle sectors"
```

### Integration Examples
```
"结合微博热搜分析进行市场调研，创建创业项目提案"
```
```
"Combine Weibo hot search analysis with market research to create startup pitch deck"
```

## Input Requirements

### Automated Data Collection
- **TianAPI Integration**: Uses Weibo hot search API endpoint
- **Default Analysis Scope**: Analyzes top 10 trending topics
- **Web Search Integration**: Automatically searches for background information

### Customizable Parameters
- **Analysis Scope**: Number of hot topics to analyze (default: 10, max: 20)
- **Creative Ideas per Topic**: Number of ideas generated per topic (default: 3)
- **Output Format**: HTML report with visualizations

### Optional Parameters
- **Industry Focus**: Specific market sectors to prioritize
- **Scoring Weights**: Custom interestingness/usefulness ratios (default: 80/20)
- **Report Title**: Custom report title and branding

## Output Deliverables

### Primary Output: Professional HTML Analysis Report
- **Executive Summary**: Key statistics and findings overview
- **Trend Timeline**: Visual timeline of hot topics and their relationships
- **Product Ideas**: Detailed concept cards with scoring breakdown
- **Market Insights**: Commentary on opportunities and challenges
- **Scoring Methodology**: Explanation of evaluation criteria

### Secondary Outputs
- **JSON Data Files**: Raw analysis data for further processing
- **Trend Metrics**: Quantitative indicators for each topic
- **Scoring Details**: Breakdown of how each score was calculated

## Scoring Algorithm

### Interestingness Score (80% weight)
- **Novelty Factor (25%)**: How unique and innovative the concept is
- **Engagement Potential (25%)**: Likely user interaction and sharing potential
- **Trend Alignment (15%)**: How well it connects to current cultural moments
- **Storytelling Potential (15%)**: Narrative value and viral potential

### Usefulness Score (20% weight)
- **Problem-Solving Capability (10%)**: Addressing real user needs
- **Market Viability (5%)**: Commercial potential and feasibility
- **User Value (5%)**: Tangible benefits to target audience

### Score Categories
- **Excellent (80-100 points)**: Gold highlighting - High-priority development candidates with strong market potential
- **Good (60-79 points)**: Blue highlighting - Promising concepts worth exploring and further development
- **Moderate (40-59 points)**: Gray highlighting - Niche opportunities with potential but limited appeal
- **Limited (0-39 points)**: Lower priority concepts that need significant improvement or new direction

## Technical Implementation

### System Architecture
```
weibo-hotsearch-idea-analyzer/
├── src/
│   ├── core/
│   │   ├── tianapi_scraper.py        # TianAPI integration for Weibo data
│   │   ├── news_analyzer.py          # Web search and background analysis
│   │   ├── idea_generator.py         # AI-powered creative idea generation
│   │   └── scorer.py                 # 80/20 scoring algorithm implementation
│   ├── config/
│   │   └── api_config.py             # API keys and configuration
│   ├── templates/
│   │   └── report_template.html      # Professional HTML report template
│   └── utils/
│       └── html_generator.py         # Report generation engine
├── output/
│   └── reports/                      # Generated analysis reports
└── SKILL.md                          # This configuration file
```

### Key Dependencies
- **TianAPI**: Weibo hot search data source
- **Web Search API**: Background research and news gathering
- **Jinja2**: HTML template rendering
- **Requests**: HTTP client for API calls

### Data Processing Pipeline
1. **API Integration**: Connect to TianAPI for real-time hot search data
2. **Web Research**: Automated background research using web search
3. **AI Analysis**: Process collected data for creative insights
4. **Scoring Engine**: Apply dual-criteria evaluation framework
5. **Report Generation**: Create professional HTML output

## Error Handling & Edge Cases

### Data Collection Issues
- **API Failures**: Graceful fallback with cached data or user input
- **Search Limitations**: Handle web search quotas and connection issues
- **Data Validation**: Ensure collected data meets quality standards
- **Rate Limiting**: Respect API rate limits and implement retry logic

### Analysis Challenges
- **Topic Ambiguity**: Handle vague or unrelated trending topics
- **Creative Blocks**: Provide fallback idea generation strategies
- **Scoring Consistency**: Maintain consistent evaluation criteria across topics
- **Cultural Context**: Understand Chinese social media trends and context

## Quality Assurance

### Validation Processes
- **Data Verification**: Cross-reference hot topics with multiple sources
- **Scoring Consistency**: Ensure consistent evaluation across similar concepts
- **Report Testing**: Validate HTML rendering on different devices and browsers
- **Content Review**: Ensure generated ideas are relevant and valuable

### Continuous Improvement
- **Model Updates**: Regular scoring algorithm refinement based on feedback
- **Template Enhancement**: Ongoing design improvements for better readability
- **Research Expansion**: Enhanced web search for more comprehensive background data
- **User Feedback**: Incorporate user suggestions for improved analysis

## Performance Considerations

### Optimization Strategies
- **Caching**: Cache background research to avoid redundant searches
- **Batch Processing**: Process multiple topics efficiently
- **Parallel Requests**: Concurrent API calls where appropriate
- **Resource Management**: Efficient memory usage for large datasets

### Rate Limiting
- **API Quotas**: Respect TianAPI and web search rate limits
- **Request Throttling**: Implement appropriate delays between requests
- **Error Recovery**: Robust handling of network and API failures

## Integration Capabilities

### Complementary Tools
- **Market Research Platforms**: Enhanced industry analysis
- **Startup Ecosystem**: Integration with incubators and accelerators
- **Product Management Tools**: Export to product roadmap software
- **Collaboration Platforms**: Share reports with team members

### Data Export Options
- **JSON Format**: Raw data for further analysis
- **CSV Export**: Spreadsheet-compatible data for business users
- **PDF Reports**: Print-friendly versions for presentations
- **API Access**: Programmatic access for integration

## Best Practices

### For Optimal Results
- **Clear Objectives**: Define specific goals before analysis
- **Regular Updates**: Analyze trends consistently for better insights
- **Market Context**: Consider broader market conditions when evaluating ideas
- **User Validation**: Validate generated concepts with target users

### Report Interpretation
- **Score Context**: Consider scoring methodology when evaluating ideas
- **Market Timing**: Assess current market readiness for each concept
- **Resource Requirements**: Evaluate implementation complexity and resource needs
- **Competitive Landscape**: Research existing solutions before development

## Limitations & Considerations

### Scope Boundaries
- **Geographic Focus**: Primarily Chinese market trends and user preferences
- **Language Support**: Optimized for Chinese language content and context
- **Data Sources**: Limited to available web search results and API data
- **Time Sensitivity**: Trend analysis reflects current moment in time

### Subjectivity Considerations
- **Creative Assessment**: Interestingness scoring involves creative judgment
- **Market Estimation**: Market potential estimates based on available data
- **Cultural Factors**: Analysis reflects current cultural context and trends
- **Technology Assumptions**: Technical feasibility assessments may vary

## Security & Privacy

### Data Protection
- **API Key Management**: Secure handling of API credentials
- **Data Minimization**: Only collect necessary data for analysis
- **Content Filtering**: Appropriate content filtering and validation
- **User Privacy**: No personal data collection or storage

### Compliance Considerations
- **Terms of Service**: Compliance with API provider terms
- **Copyright**: Respectful use of copyrighted materials
- **Attribution**: Proper attribution for source materials
- **Fair Use**: Appropriate use of publicly available information